const system = require("../../system");
const Dao = require("../dao.base");
class OrderDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderDao));
  }
  extraWhere(obj, w) {
    console.log("---------------------------------------------------------------------------------zhangjiao");
    console.log(obj);
    if (obj.codepath && obj.codepath != "") {
      if (obj.codepath.indexOf("myordermag") >= 0) {
        //如果是我的订单，查询条件是订单等于当前登录人的onlyCode
        w["createuser_id"] = obj.uid;
      } else if (obj.codepath.indexOf("myorder") >= 0) {
        if (obj.mobile) {
          w[this.db.Op.or] = [
            { createuser_id: obj.uid }, { mobile: obj.mobile },
          ];
        } else {
          w["createuser_id"] = obj.uid;
        }

      }
      else if (obj.codepath.indexOf("flowaudit") >= 0) {//流程审核
        w["orderPayStatus"] = 'yfk';
        // w["orderStatus"] = '3';
        w[this.db.Op.or] = [
          { "orderStatus": '3' }, { "orderStatus": '5' },
        ];
        w["auditStatus"] = 'tg';
      }
    }
    return w;
  }
  extraModelFilter() {
    return {
      "key": "include", "value": [
        { model: this.db.models.customerinfo, as: "customerinfo" },
        { model: this.db.models.user, as: "createuser" }
      ]
    };
  }
  async findOneByCode(code) {
    return this.model.findOne({ "where": { "code": code } });
  }
  async findItemByCode(code) {
    return this.model.findOne({
      "where":
        { "code": code },
      attributes: ["busPayOrderCode", "wxPayOrderCode", "aliPayOrderCode", "code", "company_id", "name", "subType", "sveItemCode", "sveItemName", "totalSum", "orderPayStatus"],
      raw: true
    });
  }
}
module.exports = OrderDao;
// var test = new OrderDao();
// test.getTmOrderDetail("TMO201903211634nBfmN").then(function(d){
//   console.log("ddddddddddddd");
//   console.log(d);
// })
