const system = require("../../system");
const Dao = require("../dao.base");
class TlOrderDao extends Dao {
  constructor() {
    super(Dao.getModelName(TlOrderDao));
  }
  async findItemByOrderNo(orderNo) {
    return this.model.findOne({
      "where":
        { "orderNo": orderNo },
      attributes: ["orderNo", "busPayOrderCode", "wxPayOrderCode", "aliPayOrderCode",
        "orderPayStatus", "company_id", "other_company_id"],
      raw: true
    });
  }
  async updateByOrderNo(setField, orderNo) {
    await this.updateByWhere(setField, { where: { orderNo: orderNo } });
  }
}
module.exports = TlOrderDao;
