module.exports = {
  "bizName": "article",
  "list": {
    columnMetaData: [
      { "width": "150", "label": "创建时间", "prop": "created_at", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "收款项目", "prop": "sveItemName", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "账户", "prop": "moneyaccount.name", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "支付单号", "prop": "payOrderNo", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "说明", "prop": "notes", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "金额", "prop": "totalSum", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "审核者", "prop": "auditor", "isShowTip": true, "isTmpl": false },
      { "width": "150", "label": "审核状态", "prop": "auditStatusName", "isShowTip": true, "isTmpl": false },
      { "width": "150", "label": "收款类型", "prop": "receiptTypeName", "isShowTip": true, "isTmpl": false },
      { "width": "150", "label": "支付类型", "prop": "accountTypeName", "isShowTip": true, "isTmpl": false },
      { "width": "30%", "label": "来源单号", "prop": "sourceOrderNo", "isShowTip": true, "isTmpl": false },
      { "width": "100", "label": "审核备注", "prop": "opNotes", "isShowTip": true, "isTmpl": false },
      { "width": "null", "label": "操作", "name": "null", "isShowTip": false, "isTmpl": true, "isBtns": "true" },
    ]
  },
  "form": [
    {
      "title": "基本信息",
      "colnum": 2,
      ctls: [
        { "type": "select", "refModel": "moneyaccount", "isMulti": false, "label": "收款账户", "prop": "moneyaccount_id", "labelField": "name", "valueField": "id", "style": "", rules: [{ "required": true, "message": '请选择收款账户', "trigger": 'blur' },] },
        { "type": "select", "label": "收款来源", "dicKey": "accountType", "prop": "accountType", "labelField": "label", "valueField": "value", "placeHolder": "请选择收款来源", "style": "", rules: [{ "required": true, "message": '请输入收款来源', "trigger": 'blur' },] },
        { "type": "select", "label": "收款类型", "dicKey": "receipt_type", "prop": "receiptType", "labelField": "label", "valueField": "value", "placeHolder": "请选择收款类型", "style": "", rules: [{ "required": true, "message": '请输入收款类型', "trigger": 'blur' },] },
        { "type": "input", "label": "金额", "prop": "totalSum", "placeHolder": "请输入收款总额", "style": "", rules: [{ "required": true, "message": '请输入总额', "trigger": 'blur' },] },
        // { "type": "select", "label": "来源类型", "dicKey": "source_type", "prop": "sourceType", "labelField": "label", "valueField": "value", "placeHolder": "请选择来源类型", "style": "", rules: [{ "required": true, "message": '请输入来源类型', "trigger": 'blur' },] },
        { "type": "input", "label": "收款单号", "prop": "code", "placeHolder": "请输入收款单号", "style": "", disabled: true, rules: [{ "required": true, "message": '请输入收款单号', "trigger": 'blur' },] },
        { "type": "input", "label": "来源类型", "prop": "sourceType", "placeHolder": "请输入来源类型", "style": "", disabled: true, rules: [{ "required": true, "message": '请输入费用单号', "trigger": 'blur' },] },
      ]
    },
    {
      "title": "支付信息",
      "colnum": 2,
      ctls: [
        { "type": "input", "label": "支付单号", "prop": "payOrderNo", "placeHolder": "请输入支付单号", "style": "" },
      ]
    },
    {
      "title": "审核备注",
      "colnum": 2,
      ctls: [
        { "type": "input", "label": "备注", "prop": "notes", "style": "", "disabled": true },
      ]
    },
  ],
  "search": [
    {
      "title": "基本查询",
      ctls: [
        // { "type": "select", "refModel": "moneyaccount", "isMulti": false, "label": "收款账户", "prop": "moneyaccount_id", "labelField": "name", "valueField": "id", "style": "" },
        { "type": "select", "label": "支付类型", "dicKey": "accountType", "prop": "accountType", "labelField": "label", "valueField": "value", "placeHolder": "请选择支付类型", "style": "" },
        { "type": "input", "label": "支付单号", "prop": "payOrderNo", "placeHolder": "请输入支付单号", "style": "" },
        // { "type": "input", "label": "创建者", "prop": "creator", "placeHolder": "请输入创建者", "style": "" },
        { "type": "input", "label": "审核者", "prop": "auditor", "placeHolder": "请输入审核者", "style": "" },
        { "type": "select", "label": "审核状态", "dicKey": "audit_status", "prop": "auditStatus", "labelField": "label", "valueField": "value", "placeHolder": "请选择审核状态", "style": "" },
        { "type": "select", "label": "来源类型", "dicKey": "source_type", "prop": "sourceType", "labelField": "label", "valueField": "value", "placeHolder": "请选择来源类型", "style": "" },
        { "type": "input", "label": "来源单号", "prop": "sourceOrderNo", "placeHolder": "请输入来源单号", "style": "" },
      ]
    },
  ],
  "auth": {
    "add": [
      { "icon": "el-icon-plus", "title": "新增", "type": "default", "key": "new", "isOnGrid": true },
      { "icon": "el-icon-plus", "title": "审核", "type": "default", "key": "audit", "isOnGrid": true },
      { "icon": "el-icon-save", "title": "保存", "type": "default", "key": "save", "isOnForm": true },
    ],
    "edit": [
      // {"icon":"el-icon-edit","title":"修改","type":"default","key":"edit","isInRow":true},
      { "icon": "el-icon-edit", "title": "联查订单", "type": "default", "key": "linkquery", "isInRow": true },
      { "icon": "el-icon-edit", "title": "查看凭证", "type": "default", "key": "queryPayVoucher", "isInRow": true },
    ],
    // "delete":[
    //   {"icon":"el-icon-remove","title":"删除","type":"default","key":"delete","isInRow":true},
    // ],
    "common": [
      { "icon": "el-icon-cancel", "title": "取消", "type": "default", "key": "cancel", "isOnForm": true },
    ],
  }

}
