const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("buscompanynotes", {
    // 引用表的信息:
    // this.db.models.buscompanynotes.belongsTo(this.db.models.company, { constraints: false, });
    // this.db.models.businesscompany.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });//创建人
    // this.db.models.buscompanynotes.belongsTo(this.db.models.businesscompany, { constraints: false, });//商机id  
    tm_company_type_name: DataTypes.STRING(50),//商机类型名称
    tm_company_type: {//商机类型：xz: 商标续展，kz：商标宽展，bh: 商标驳回复审，bysl: 商标不予受理，yy: 商标异议，bg: 商标变更
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_company_type),
      set: function (val) {
        this.setDataValue("tm_company_type", val);
        this.setDataValue("tm_company_type_name", uiconfig.config.pdict.tm_company_type[val]);
      }
    },  
    customer_intention_name: DataTypes.STRING(50),//客户意向名称
    customer_intention: {//客户意向：yxyb: 意向一般, yxhg: 重要意向, wjt: 未接通
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.customer_intention),
      set: function (val) {
        this.setDataValue("customer_intention", val);
        this.setDataValue("customer_intention_name", uiconfig.config.pdict.customer_intention[val]);
      }
    },   
    notes: DataTypes.STRING,//备注
    op_notes: DataTypes.STRING(50),//操作备注   
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'bi_buscompany_notes',
      validate: {

      },
      indexes: [
      ]
    });
}
