const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    //表引用
    // this.db.models.loopplay.belongsTo(this.db.models.sitetheme, { constraints: false, });

    return db.define("loopplay", {
        code: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        title: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        leftimg: {
            type: DataTypes.STRING,
        },//需要在后台补充
        rightimg: {
            type: DataTypes.STRING,
        },//需要在后台补充
        orderNo: {//序号
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        loopplayTypeName: {
            type: DataTypes.STRING(50),
            defaultValue: "PC",
        },
        loopplayType: {//YD为移动端轮播图，YDAD为移动端广告图，PC为PC端轮播图，PCAD为PC端广告图
            type: DataTypes.ENUM,
            values: Object.keys(uiconfig.config.pdict.loopplay_type),
            defaultValue: "PC",
            set: function (val) {
                this.setDataValue("loopplayType", val);
                this.setDataValue("loopplayTypeName", uiconfig.config.pdict.loopplay_type[val]);
            }
        },
        skipUrl: DataTypes.STRING(500), // 跳转路径
    }, {
            paranoid: true,//假的删除
            underscored: true,
            version: true,
            freezeTableName: true,
            //freezeTableName: true,
            // define the table's name
            tableName: 'cms_loopplay',
            validate: {},
            indexes: [
                // Create a unique index on email
                //  {
                //    unique: true,
                //    fields: ['email']
                //  },
                //
                //  // Creates a gin index on data with the jsonb_path_ops operator
                //  {
                //    fields: ['data'],
                //    using: 'gin',
                //    operator: 'jsonb_path_ops'
                //  },
                //
                //  // By default index name will be [table]_[fields]
                //  // Creates a multi column partial index
                //  {
                //    name: 'public_by_author',
                //    fields: ['author', 'status'],
                //    where: {
                //      status: 'public'
                //    }
                //  },
                //
                //  // A BTREE index with a ordered field
                //  {
                //    name: 'title_index',
                //    method: 'BTREE',
                //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
                //  }
            ]
        });
}
