const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("oplog", {
    opTitle: DataTypes.STRING(500),
    content: {
      type: DataTypes.STRING(4000),
    },
    clientIp: DataTypes.STRING,
    logLevel: {// "debug": 0, "info": 1, "warn": 2, "error": 3, "fatal": 4 
      type: DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.logLevel),
      defaultValue: "info",
    },
    agent: DataTypes.STRING(1000),//请求头
    op: DataTypes.STRING(500),//操作url

    company_id: DataTypes.INTEGER,//公司id
    user_id: DataTypes.INTEGER,//信息user，如创建订单的用户id
    createuser_id: DataTypes.INTEGER,//创建此条记录的用户id
    sourceOrderNo: DataTypes.STRING,//来源单号 
    paySourceOrderNo: DataTypes.STRING,//支付来源单号
    opLogTypeName: {
      type: DataTypes.STRING(50),
      defaultValue: "其他",
    },
    opLogType: {//操作类型，other: 其他, payCallback: 支付回调, pfTransfer: 平台转账, officialDownload: 官文下载, publicExpense: 官费扣除, orderSettlement: 订单利润结算
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.op_log_type),
      defaultValue: "other",
      set: function (val) {
        this.setDataValue("opLogType", val);
        this.setDataValue("opLogTypeName", uiconfig.config.pdict.op_log_type[val]);
      }
    },
    opLogStatusName: {
      type: DataTypes.STRING(50),
      defaultValue: "成功",
    },
    opLogStatus: {//操作状态，fail: 失败, success: 成功, waitingProcess: 等待处理
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.op_log_status),
      defaultValue: "success",
      set: function (val) {
        this.setDataValue("opLogStatus", val);
        this.setDataValue("opLogStatusName", uiconfig.config.pdict.op_log_status[val]);
      }
    },
    totalSum: DataTypes.DECIMAL(12, 2),//总额
    notes: DataTypes.STRING(4000)//备注   
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'op_log',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
