const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("user", {
    userName: DataTypes.STRING,//用户名
    password: DataTypes.STRING,//密码-md5加密
    nickName: {//昵称
      type: DataTypes.STRING,
      allowNull: true,
    },
    headUrl: DataTypes.STRING,//头像
    // from: DataTypes.STRING,
    isAdmin: {//是否是管理员
      type: DataTypes.BOOLEAN,
      defaultValue: false
    },
    isSuper: {//是否是超管
      type: DataTypes.BOOLEAN,
      defaultValue: false
    },
    isEnabled: {//是否启用
      type: DataTypes.BOOLEAN,
      defaultValue: true
    },
    sex: {//性别
      type: DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(uiconfig.config.pdict.sex),
    },
    mobile: DataTypes.STRING,//手机号
    email: DataTypes.STRING(50),//邮箱
    companyName: DataTypes.STRING,//用户公司名称
    companyAddr: DataTypes.STRING,//公司地址
    notifyOpenId: DataTypes.STRING,   // 公众号通知微新id
    bindOpenId: DataTypes.STRING,   // 公众号绑定微新id 用于h5页面登录绑定
    isSystem: {//是否系统数据,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    freeBusNum: {//免费商机次数
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_user',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
