const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    // this.db.models.wxuser.belongsTo(this.db.models.company, { as: 'company', constraints: false, });
    return db.define("wxuser", {
        appid: {//公众号appid
            type: DataTypes.STRING,
            allowNull: false,
        },
        openid:{//用户openid
            type: DataTypes.STRING,
            allowNull: false,
        },

        nick_name:DataTypes.STRING(50),//授权方昵称
        head_img:DataTypes.STRING(50),//授权方头像
        mobile:DataTypes.STRING(50),//微信绑定电话
        notes: DataTypes.STRING,//备注
        op_notes: DataTypes.STRING(50),//操作备注 
        
        sex:DataTypes.STRING(50),//用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
        city:DataTypes.STRING(50),//用户所在城市
        country:DataTypes.STRING(50),//用户所在国家
        province:DataTypes.STRING(50),//用户所在省份
        language:DataTypes.STRING(50),//用户的语言，简体中文为zh_CN
        unionid:DataTypes.STRING(50),//只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。

        subscribe_status_name:DataTypes.STRING(50),
        subscribe_status:{//订阅状态  "wxop_subscribe_status":{"subscribe":"订阅","unsubscribe":"取消订阅"},
            type: DataTypes.ENUM,
            values: Object.keys(uiconfig.config.pdict.wxop_subscribe_status),
            set: function (val) {
              this.setDataValue("subscribe_status", val);
              this.setDataValue("subscribe_status_name", uiconfig.config.pdict.wxop_subscribe_status[val]);
            }
        },

    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'wx_user',
        validate: {},
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}
