const system = require("../../system");
const ServiceBase = require("../sve.base");
class BytmResultService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(BytmResultService));
    this.bytmmonit = system.getObject("api.bytmmonit");
  }
  async getItem(code, total_type) {
    return this.findOne({ monitCode: code, resultType: total_type });
  }
  async addItem(code, total_type, result_data) {
    var param = {
      monitCode: code,
      resultType: total_type,
      createNum: result_data.length,
      resultData: JSON.stringify(result_data)
    };
    this.create(param);
  }
  //获取操作商标监控查询--//从数据库中查询数据--供bytmmonitCtl->getMonitListDetails方法使用
  async getTmMonitQueryByDb(tCode, total_type, query) {
    var result = {
      code: 1,
      message: "success",
      data: []
    };
    if (total_type && total_type != "undefined" && total_type != -1) {
      //可显示的最大条数
      let totalNum = 1000;
      var pagesize = query.page_size == null ? 20 : query.page_size;
      var from = query.current_page == null ? 0 : Number((query.current_page - 1) * query.page_size);
      //是否更改列表中的阴影显示
      var isPutDbIsShadow = -1;
      //是从ddl中查询的
      if (query.ddl_query == 1) {
        //可无效条数
        var kwx_total = 0;
        isPutDbIsShadow = total_type == 1 ? 1 : -1;
        var kwx_result = await this.getTmMonitQueryCountByDb(tCode, 1, query, isPutDbIsShadow);
        if (kwx_result.code == -100) {
          //从es中获取
          kwx_total = await this.bytmmonit.getTmMonitCountByDb(1, query);
        } else {
          kwx_total = kwx_result.total_count;
        }
        //可撤三条数
        var kcs_total = 0;
        isPutDbIsShadow = total_type == 2 ? 1 : -1;
        var kcs_result = await this.getTmMonitQueryCountByDb(tCode, 2, query, isPutDbIsShadow);
        if (kcs_result.code == -100) {
          //从es中获取
          kcs_total = await this.bytmmonit.getTmMonitCountByDb(2, query);
        } else {
          kcs_total = kcs_result.total_count;
        }
        //可续展条数
        var kxz_total = 0;
        isPutDbIsShadow = total_type == 3 ? 1 : -1;
        var kxz_result = await this.getTmMonitQueryCountByDb(tCode, 3, query, isPutDbIsShadow);
        if (kxz_result.code == -100) {
          //从es中获取
          kxz_total = await this.bytmmonit.getTmMonitCountByDb(3, query);
        } else {
          kxz_total = kxz_result.total_count;
        }
        //可宽展条数
        var kkz_total = 0;
        isPutDbIsShadow = total_type == 4 ? 1 : -1;
        var kkz_result = await this.getTmMonitQueryCountByDb(tCode, 4, query, isPutDbIsShadow);
        if (kkz_result.code == -100) {
          //从es中获取
          kkz_total = await this.bytmmonit.getTmMonitCountByDb(4, query);
        } else {
          kkz_total = kkz_result.total_count;
        }
        //可异议条数
        var kyy_total = 0;
        isPutDbIsShadow = total_type == 5 ? 1 : -1;
        var kyy_result = await this.getTmMonitQueryCountByDb(tCode, 5, query, isPutDbIsShadow);
        if (kyy_result.code == -100) {
          //从es中获取
          kyy_total = await this.bytmmonit.getTmMonitCountByDb(5, query);
        } else {
          kyy_total = kyy_result.total_count;
        }
        //还原传递的total_type值
        query.total_type = total_type;

        result.kwx_total = kwx_total > totalNum ? totalNum : kwx_total;
        result.kcs_total = kcs_total > totalNum ? totalNum : kcs_total;
        result.kxz_total = kxz_total > totalNum ? totalNum : kxz_total;
        result.kkz_total = kkz_total > totalNum ? totalNum : kkz_total;
        result.kyy_total = kyy_total > totalNum ? totalNum : kyy_total;
        var tmpSortMonitDataList = null;
        var tmp_total_count = 0;
        switch (total_type) {
          case 1://可无效条数
            if (kwx_result.code == 1 && kwx_result.data.length > 0) {
              tmp_total_count = kwx_result.total_count;
              //从缓存中获取分页数据
              var tmpSortMonitDataList = kwx_result.data.splice(from, pagesize);
            }
            break;
          case 2://可撤三条数
            if (kcs_result.code == 1 && kcs_result.data.length > 0) {
              tmp_total_count = kcs_result.total_count;
              //从缓存中获取分页数据
              var tmpSortMonitDataList = kcs_result.data.splice(from, pagesize);
            }
            break;
          case 3://可续展条数
            if (kxz_result.code == 1 && kxz_result.data.length > 0) {
              tmp_total_count = kxz_result.total_count;
              //从缓存中获取分页数据
              var tmpSortMonitDataList = kxz_result.data.splice(from, pagesize);
            }
            break;
          case 4://可宽展条数
            if (kkz_result.code == 1 && kkz_result.data.length > 0) {
              tmp_total_count = kkz_result.total_count;
              //从缓存中获取分页数据
              var tmpSortMonitDataList = kkz_result.data.splice(from, pagesize);
            }
            break;
          case 5://可异议条数
            if (kyy_result.code == 1 && kyy_result.data.length > 0) {
              tmp_total_count = kyy_result.total_count;
              //从缓存中获取分页数据
              var tmpSortMonitDataList = kyy_result.data.splice(from, pagesize);
            }
            break;
          case 6:
            // if (listRsult.code == 1) {
            //   //从缓存中获取分页数据
            //   var tmpSortMonitDataList = sortMonitDataList.splice(from, pagesize);        
            // }
            break;
          default:
            break;
        }
        //处理过滤的结果
        if (!tmpSortMonitDataList || tmpSortMonitDataList.length == 0) {
          return result;
        }
        //从es中进行查询
        var list = await this.bytmmonit.getEsDataByDb(total_type, tmpSortMonitDataList);
        result.data = list;
        //从es中获取全部的总条数
        result.total_count = tmp_total_count;
      }
      else {
        isPutDbIsShadow = 1;
        var listRsult = await this.getTmMonitQueryCountByDb(tCode, total_type, query, isPutDbIsShadow);
        var tmpSortMonitDataList = null;
        if (listRsult.code == 1 && listRsult.data.length > 0) {
          //从缓存中获取分页数据
          tmpSortMonitDataList = listRsult.data.splice(from, pagesize);
          if (!tmpSortMonitDataList || tmpSortMonitDataList.length == 0) {
            return result;
          }
          //从es中进行查询
          var list = await this.bytmmonit.getEsDataByDb(total_type, tmpSortMonitDataList);
          result.data = list;
          result.total_count = listRsult.total_count;
        }
      }
      return result;
    }
    result.code = -101;
    result.message = "全部数据，无需处理";
    return result;
  }

  //获取操作商标监控查询--//从数据库中查询数据--供bytmmonitCtl->getMonitListDetails方法使用
  async getTmMonitQueryCountByDb(tCode, total_type, query, isPutDbIsShadow) {
    var result = {
      code: 1,
      message: "success",
      data: []
    };
    if (total_type && total_type != "undefined" && total_type != -1) {
      var monitDataStr = await this.cacheManager["TmMonitQueryCache"].getListByCache(tCode, total_type);
      if (!monitDataStr || monitDataStr.length < 20) {
        result.code = -100;
        result.message = "数据库中没有此类数据";
        return result;
      }
      var monitDataList = JSON.parse(monitDataStr);
      //条件信息
      var apply_year = query.apply_year || -1;
      var status = query.status || -1;
      var ncl_one_codes = query.ncl_one_codes || -1;
      var pagesize = query.page_size == null ? 20 : query.page_size;
      var from = query.current_page == null ? 0 : Number((query.current_page - 1) * query.page_size);

      var filterList = null;
      if (apply_year != -1 && status != -1 && ncl_one_codes != -1) {
        filterList = monitDataList.filter(f => f.apply_year == apply_year && f.ncl_one_codes == ncl_one_codes && f.status == status);
      }
      else if (apply_year != -1 && status != -1 && ncl_one_codes == -1) {
        filterList = monitDataList.filter(f => f.apply_year == apply_year && f.status == status);
      }
      else if (apply_year != -1 && ncl_one_codes != -1 && status == -1) {
        filterList = monitDataList.filter(f => f.apply_year == apply_year && f.ncl_one_codes == ncl_one_codes);
      }
      else if (status != -1 && ncl_one_codes != -1 && apply_year == -1) {
        filterList = monitDataList.filter(f => f.ncl_one_codes == ncl_one_codes && f.status == status);
      }
      else if (apply_year != -1 && status == -1 && ncl_one_codes == -1) {
        filterList = monitDataList.filter(f => f.apply_year == apply_year);
      }
      else if (status != -1 && apply_year == -1 && ncl_one_codes == -1) {
        filterList = monitDataList.filter(f => f.status == status);
      }
      else if (ncl_one_codes != -1 && apply_year == -1 && status == -1) {
        filterList = monitDataList.filter(f => f.ncl_one_codes == ncl_one_codes);
      }
      else {
        filterList = monitDataList;
      }
      //排序规则：倒序正序，<倒序，>正序
      var sortMonitDataList = filterList.sort((a, b) => {
        if (a.op_time < b.op_time) {  // 可以改成其他key
          return 1
        } else {
          return -1
        }
      });
      result.data = sortMonitDataList;
      const tmp_total_count = filterList.length;
      result.total_count = tmp_total_count > 1000 ? 1000 : tmp_total_count;
      if (isPutDbIsShadow == 1) {//是否更改列表中的阴影显示
        var ttIndex = monitDataStr.indexOf("\"is_shadow\":1");
        if (ttIndex >= 0) {
          var tmpStr = monitDataStr.replace(/"is_shadow":(\d*)/g, '"is_shadow":0');
          this.dao.model.update({ resultData: tmpStr }, { where: { monitCode: tCode, resultType: total_type } });
          this.cacheManager["TmMonitQueryCache"].delCache(tCode, total_type);
        }
      }
      return result;
    }
    result.code = -101;
    result.message = "全部数据，无需处理";
    return result;
  }

}
module.exports = BytmResultService;
