const system=require("../../system");
const ServiceBase=require("../sve.base")
const settings=require("../../../config/settings")
class NeedService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(NeedService));
    }
  async findchance(obj){
    return this.dao.model.findOne({where:obj});
  }
  //提交备注
  async submitRemarks(obj){
    var user = obj.user;
    var id = obj.id;
    var customer_intention = obj.customer_intention;
    var opNotes =null;
    var opNotesList=[];
    if(!id){
      return {code:-1,msg:"id参数错误"};
    }
    if(!customer_intention){
      return {code:-2,msg:"customer_intention参数错误"};
    }
    if(obj.desc && obj.desc.length>50){
      return {code:-3,msg:"备注内容字数不能超过50"};
    }
    var oldNeed = await this.dao.findById(id);
    if(!oldNeed){
      return {code:-4,msg:"需求不存在"};
    }
    var d = new Date();
    var datetime=d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();
    var intentionenum ={ "yxyb": "意向一般", "yxhg": "重要意向", "wjt": "未接通" };
    var noteObj={
      customer_intention:intentionenum[customer_intention],desc:obj.desc || "",time:datetime,creator:user.nickName
    }
    if(oldNeed && oldNeed.opNotes){
      var opNotesObj = JSON.parse(oldNeed.opNotes);
      opNotesList = opNotesObj.opNotes;
      opNotesList.unshift(noteObj);

    }else{
      opNotesList=[noteObj];
    }
    opNotes ={opNotes:opNotesList};
    opNotes = JSON.stringify(opNotes);
    var obj={
      id:id,opNotes:opNotes
    }
    await this.dao.update(obj);
    return {code:1};
  }


}
module.exports=NeedService;
