const system=require("../../system");
const ServiceBase=require("../sve.base");
class PConfigService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(PConfigService));
     //this.appDao=system.getObject("db.appDao");
  }
  async findOrSetPrice(num,appkey){
     return this.cacheManager["PriceConfigCache"].cacheGlobalVal(num,appkey);
  }
  async create(qobj){
    await this.cacheManager["PConfigCache"].invalidateCache();
    await this.cacheManager["InitGiftCache"].invalidateCache();
    return this.dao.create(qobj);
  }
  async update(qobj,tm=null){
    await this.cacheManager["PConfigCache"].invalidateCache();
    await this.cacheManager["InitGiftCache"].invalidateCache();
    return this.dao.update(qobj,tm);
  }
  async updateByWhere(setObj,whereObj,t){
    await this.cacheManager["PConfigCache"].invalidateCache();
    await this.cacheManager["InitGiftCache"].invalidateCache();
    return this.dao.updateByWhere(setObj,whereObj,t);
  }
  //获取配置的发票税率
  async getInvoiceTaxRate(){
    var tmpInvoiceTaxRate=7;
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === "invoiceTaxRate";
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      tmpInvoiceTaxRate=Number(pconfigResult.configValue);
    }
    return tmpInvoiceTaxRate;
  }
  //获取配置的推荐人分润比例
  async getReferrerProfitRatio(){
    var tmpInvoiceTaxRate=10;
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === "referrerProfitRatio";
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      tmpInvoiceTaxRate=Number(pconfigResult.configValue);
    }
    return tmpInvoiceTaxRate;
  }
  //商机分配渠道配置，格式：wssyh5,yzc等
  async getBussinessAllotChannelConfig(){
    var bussinessAllotChannel="wssyh5";
    var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
    var pconfigResult= pconfig.find(item => {
        return item.configType === "bussinessAllotChannelConfig";
    });
    if(pconfigResult!=null && pconfigResult.configValue!=null && pconfigResult.configValue!=""){
      bussinessAllotChannel=pconfigResult.configValue;
    }
    return bussinessAllotChannel;
  }
}
module.exports=PConfigService;
