{
  template:'${tmpl}',
  data:function(){
      var validateMobile = (rule, value, callback) => {
        if(this.a==true){
          if (value === '') {
            callback(new Error('请输入更换绑定的电话号码'));
          }else if(value==this.mobile){
            callback(new Error('您当前绑定的电话号码正是'+this.mobile));
          }
        }
        callback();
      };
      var validatePass = (rule, value, callback) => {
        if(this.b==true){
          if (value === '') {
            callback(new Error('请输入密码'));
          }else if(value.length<6||value.length>18){
            callback(new Error('密码长度6-18位'));
          }else{
            if (this.form.password2 !== '') {
              this.$refs.form.validateField('password2');
            }
            callback();
          }
        }
        callback();
      };
      var validatePass2 = (rule, value, callback) => {
        if(this.b==true){
          if (value === '') {
            callback(new Error('请再次输入密码'));
          } else if (value !== this.form.password) {
            callback(new Error('两次输入密码不一致!'));
          }
        }
        callback();
      };
      var validateVcode = (rule, value, callback) => {
        if(this.c==true){
          if (value === '') {
            callback(new Error('请输入验证码'));
          }else if(value!=this.vcode){
            callback(new Error('验证码输入错误'));
          }
        }
        callback();
      };
      return {
        a:false,
        b:false,
        c:false,
        mobile:"",
        vcode:"",
        form:{
          created_at:"",
          nickName:"",
          userName:"",
          mobile:"",
          email:"",
          password:"",
          password2:"",
          vcode:""
        },
        rules:{
          mobile:[
            { validator: validateMobile, trigger: 'blur' }
          ],
          password:[
             { validator: validatePass, trigger: 'blur' }
          ],
          password2:[
             { validator: validatePass2, trigger: 'blur' }
          ],
          vcode:[
            { validator: validateVcode, trigger: 'blur' }
          ]
        }
      }
  },
  mounted:function(){
  },
  created:function(){
    console.log(this.currentUser);
    var date = new Date(this.currentUser.created_at);
    this.form.created_at=date.toLocaleDateString();
    this.form.nickName=this.currentUser.nickName;
    this.form.userName=this.currentUser.userName;
    this.mobile=this.currentUser.mobile;
    this.form.email=this.currentUser.email;
  },
  methods:{
    auditmobile(){
      this.a=true;
    },
    auditpassword(){
      this.b=true;
    },
    fetchVcode(){
      var that=this;
      that.$refs.form.validate(valid=>{
        if(valid){
          var obj={mobile:""};
          if(that.b==true&&that.a==false){
            obj.mobile=that.mobile;
            that.$root.postReq("/web/userCtl/obtaincode2",obj).then(function(d){
              if(d.status==0){
                that.vcode=d.data.vcodestr;
                that.c=true;
              }
            })
          }else{
            obj.mobile=that.form.mobile;
            that.$root.postReq("/web/userCtl/obtaincode3",obj).then(function(d){
              if(d.status==0){
                that.vcode=d.data.vcodestr;
                that.c=true;
              }else{
                that.$message({
                    type: 'error',
                    message: '用户已存在, 请修改并重试'
                  });
              }
            })
          }
        }
      });

    },
    saveUserinfo(){
      var that=this;
      that.$refs.form.validate(valid=>{
        if(valid){
          var obj={
            userName:that.form.userName,
            nickName:that.form.nickName,
            email:that.form.email,
            mobile:"",
            password:that.form.password
          };
          if(that.a==false&&that.b==true){
            obj.mobile=that.mobile;
          }else if(that.a==false&&that.b==false){
            obj.mobile=that.mobile;
          }else{
            obj.mobile=that.form.mobile;
          };
          console.log("--------------resetUserInfo----------------");
          console.log(obj);
          that.$root.postReq("/web/userCtl/resetUserInfo",obj).then(function(d){
            if(d.status==0){
              that.$message({
                  type: 'success',
                  message: '账户信息更新成功'
                });
                that.currentUser.mobile=obj.mobile;
            }
          });
        }
      })
    }

  },
  vname:"gsb_actsetting"
}
