{
    template:'${tmpl}',
    data:function(){
        return {
          showSetTmType:false,
          selectedTypeRows:[],
          form:{
            tmtype:"ordinary",
          },
          trademarkData:[]
        }
    },
    mounted:function(){
      

    },
    created:function(){
   
    },
    methods:{
      setTmType(){
        var ids=[];
        console.log(this.selectedTypeRows);
        for(var i=0;i<this.selectedTypeRows.length;i++){
          ids.push(this.selectedTypeRows[i].id);
        }
        console.log(ids);
        console.log(this.form.tmtype);
        if(ids && ids.length>0 && this.form.tmtype){
          this.$root.postReq("web/trademarktransactionCtl/editTmtsType",{ids:ids,type:this.form.tmtype}).then(d=>{
            console.log("editTmtsType");
            console.log(d);
            if(d && d.code==1){
              this.showSetTmType=false;
              this.form.tmtype="ordinary";
              this.$refs.grid.fetchData();
            }else{
              this.$message.warning(d.msg);
            }
          }).catch(e=>{
            console.log(e);
            this.$message.warning("操作失败");
          })
        }
      },
      btnvisbleMethod(row,btn){
        if(btn.key=="invoiceapply"){
          if(row.orderPayStatus=="yfk"&&row.invoiceApplyStatus=="1"&&row.isIinvoice==1){
            return true;
          }else{
            return false;
          }
        }
        if(btn.key=="shangjia"){
          if(row.publish_status=="success" || row.publish_status=="lowershelf"){
            return true;
          }else{
            return false;
          }
        }
        if(btn.key=="xiajia"){
          if(row.publish_status=="uppershelf"){
            return true;
          }else{
            return false;
          }
        }
        
        return true;
      },
      onColFormater(row,column,cellvalue,index){
        if(column.property=="created_at"){
          var date = new Date(row["created_at"]);
          var time= date.toLocaleDateString();
      
          return time;
        }
        if(column.property=="tm_end_day"){
          var date = new Date(row["tm_end_day"]);
          var time= date.toLocaleDateString();
      
          return time;
        }
        return cellvalue;
      },
      exportList(){
        this.$confirm('此操作将导出商标列表数据, 是否继续?', '提示', {
            confirmButtonText: '确定',
            cancelButtonText: '取消',
            type: 'warning'
          }).then(() => {
            this.tableToExcel();
          }).catch((e)=>{
            console.log(e);
          });
        
      },
      tableToExcel(){
        var jsonData = this.trademarkData;
        var str = "<tr><td>商标图片</td><td>商标名称</td><td>价格</td><td>尼斯类别</td><td>商品服务项</td></tr>";
        for(var i = 0 ; i < jsonData.length ; i++ ){
          str+='<tr>';
          var jdata = jsonData[i];
          str+="<td>"+jdata.pic_url+"</td>"; 
          str+="<td>"+jdata.name+"</td>"; 
          str+="<td>"+jdata.platform_quoted_price+"</td>"; 
          str+="<td>"+jdata.ncl_one_code+"</td>";   
          str+="<td>"+jdata.spfwxm+"</td>";   
          str+="</tr>";
        }
        var worksheet = "Sheet1";
        var uri = 'data:application/vnd.ms-excel;base64,';
  
        var template = "<html xmlns:o=\'urn:schemas-microsoft-com:office:office\' xmlns:x=\'urn:schemas-microsoft-com:office:excel\' xmlns=\'http://www.w3.org/TR/REC-html40\'>"+
        "<head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>"+worksheet+"</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet>"+
        "</x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>"+str+"</table></body></html>";
        var oa = document.getElementById("grid2_export");
        oa.href = uri + this.base64(template);
        oa.download = "商标交易.xls";
        oa.click();
        oa.style.display='none';
      },
      base64 (s) { 
        return window.btoa(unescape(encodeURIComponent(s)));
      },
      onToolbarClick(key,t,rows){
        if(key=="batchrelease"){
         this.$root.pushx({
          title:"批量发布交易商标",
          name:"/tmtransactionbatchrelease"
         });
         return;
        }
        if(key=="myexport"){
          console.log("导出");
          if(!rows || rows.length<1){
            this.$message.warning("请选择至少一条数据");
            return;
          }
          this.trademarkData=rows;
          this.exportList();
          return;
         }
        if(key=="entrelease"){
          this.$root.pushx({
           title:"企业发布交易商标",
           name:"/tmtransactionentrelease"
          });
          return;
         }
         if(key=="changetype"){
           console.log("changetype");
           if(!rows || rows.length<1){
            this.$message.warning("请选择至少一条数据");
            return;
          }else{
            this.showSetTmType=true;
            this.selectedTypeRows=rows;
          }
         }
        if(key=="shangjia"){
          if(!rows || rows.length<1){
            this.$message.warning("请选择至少一条数据");
            return;
          }else{
            var codeList=[];
            for(var i=0;i<rows.length;i++){
              if(rows[i].publish_status=="audit" || rows[i].publish_status=="fail"){
                this.$message.warning("存在商标状态为"+rows[i].publish_status_name+"的数据，不能上架");
                return;
              }
              if(rows[i].publish_status=="uppershelf"){
                this.$message.warning("存在已上架的数据，不能再次上架");
                return;
              }
              codeList.push(rows[i].code);
            }
          }
          this.$confirm('是否上架商标?', '提示', {
            confirmButtonText: '确定',
            cancelButtonText: '取消',
            type: 'warning'
          }).then(() => {
            this.$root.showMask();
            this.$root.postReq("web/trademarktransactionCtl/updatePublishStatus",{codeList:codeList,type:1}).then(d=>{
              console.log(d);
              if(d && d.code==1){
                this.$message.success("上架成功");
                this.$refs.grid.fetchData();
              }else{
                this.$message.warning(d.msg);
              }
              this.$root.hideMask();
            }).catch(e=>{
              this.$message.warning("操作失败");
              this.$root.hideMask();
            })
          })
          
          
         }
         if(key=="xiajia"){
          var codeList=[];
          if(!rows || rows.length<1){
            this.$message.warning("请选择至少一条数据");
            return;
          }else{
            for(var i=0;i<rows.length;i++){
              if(rows[i].publish_status=="audit" || rows[i].publish_status=="fail"){
                this.$message.warning("存在商标状态为"+rows[i].publish_status_name+"的数据，不能下架");
                return;
              }
              if(rows[i].publish_status=="lowershelf"){
                this.$message.warning("存在已下架的数据，不能再次下架");
                return;
              }
              codeList.push(rows[i].code);
            }
            this.$confirm('是否下架商标?', '提示', {
              confirmButtonText: '确定',
              cancelButtonText: '取消',
              type: 'warning'
            }).then(() => {
              this.$root.showMask();
              this.$root.postReq("web/trademarktransactionCtl/updatePublishStatus",{codeList:codeList,type:2}).then(d=>{
                console.log(d);
                if(d && d.code==1){
                  this.$message.success("下架成功");
                  this.$refs.grid.fetchData();
                }else{
                  this.$message.warning(d.msg);
                }
                this.$root.hideMask();
              }).catch(e=>{
                this.$message.warning("操作失败");
                this.$root.hideMask();
              })
            })
            
          }
          
         }
      },
      onRowClick(row,key,e){
        console.log(row);
        if(key=="mydetail"){
          if(row.ncl_one_code){
            this.$root.pushx({
              title:"商标详情",
              name:"/ptmtransactiondetail",
              params:{
                code:row.code,
                ncl_one_code:row.ncl_one_code
              }
            });
          }else{
            this.$root.pushx({
              title:"商标详情",
              name:"/ptmtransactiondetail",
              params:{
                code:row.code
              }
            });
          }
        }
        if(key=="mydelete"){
          var that=this;
          if(row.orderPayStatus!="dfk"){
            this.$message({
              type: 'warning',
              message: '只能删除未付款订单'
            });
           return;
          }else{
            if(row.orderSource=="ptsj"){
              this.$confirm('此操作将删除当前记录, 是否继续?', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                type: 'warning'
              }).then(() => {
                var obj={orderNum:row.code};
                that.$root.postReq("/web/orderCtl/deletePtsjOrder",obj).then(function(d){
                  console.log("dssssssssssssssssss");
                  console.log(d);
                  if(d && d.code==1){
                    that.$message({
                      type: 'success',
                      message: '删除成功!'
                    });
                    that.$refs.grid.fetchData();
                  }else{
                    that.$message.warning(d.msg);
                  }
                }).catch(function(e){
                  console.log(e);
                  that.$message.warning("操作失败");
                })
              })
              
            }else{
              this.$refs.grid.rowClick(row,"delete","",e);
            }
          }

        }
       },

    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    vname:"gsb_mytmtransaction"
}
