{
  template: '${tmpl}',
    data: function() {
      return {
        imgHeight: null,
        orderNum: "",
        orderInfo: {},
        payType: "wx",
        d: {},
        action: "",
        zfpzUrl: "",
        accounts: [],
        account_id: "",
        account_index: "",
        accountinfo: {},
        qrcode: "",
        tradekey: "",
        time: "",
        interval: null,
        roleList: null,
        isBizemp: false,
        loading: false,
        payOrderType: false
      }
    },
  mounted: function() {
    this.imgHeight = 'min-height:' + (document.documentElement.clientHeight - 221) + "px;";
    var currentUser = this.currentUser;
    if (currentUser) {
      var roles = currentUser.roles;
      if (roles) {
        this.roleList = roles.split(",");
      }
    }
    if (this.roleList && this.roleList.length > 0) {
      for (var i = 0; i < this.roleList.length; i++) {
        if (this.roleList[i] == "bizemp") {
          this.isBizemp = true;
        }
      }
    }
    this.orderNum = this.$router.history.current.query.orderNum;
    var that = this;
    this.$root.getReq("/web/orderCtl/getItemTmOrderDetail", { orderNum: this.orderNum }).then(function (d) {
      if (d.code == 1) {
        that.orderInfo = d.data;
        that.closePayConfirm();
        that.getPayQrCode();
      }
    });
    this.$root.postReq("/web/uploadCtl/getOssConfig", "").then(function (d) {
      that.d["key"] = "key";
      that.d["Bucket"] = d.Bucket;
      that.d["OSSAccessKeyId"] = d.OSSAccessKeyId;
      that.d["Signature"] = d.Signature;
      that.d["policy"] = d.policy;
      that.d["success_action_status"] = d.success_action_status;
      that.action = d.url;
    });
    this.$root.postReq("/web/moneyaccountCtl/findAllOfflineAccount", {}).then(function (d) {
      if (d && d.code == 1) {
        that.accounts = d.data;
        if (that.accounts && that.accounts.length > 0) {
          that.account_index = 0;
          that.accountinfo = that.accounts[0];
          that.account_id = that.accountinfo.id;
        }
      } else {
        that.$message.warning("获取账户信息失败");
      }
    }).catch(function (e) {
      console.log(e);
      that.$message.warning("获取账户信息失败");
    });
  },
  created: function() {

  },
  methods: {
    afterpayjump(){
      var that = this;
      this.$root.getReq("/wxop/pushmsgWxop/getQr", {}).then(function (r) {
        console.log("rrrrrrr");
        console.log(r);
        if(r && r.code==1 && r.data){
          that.$root.pushx({
            title: "支付成功",
            name: "/paysuccess",
            params: { orderNum: that.orderNum }
          });
        }else{
          if (that.isBizemp) {
            that.$root.pushx({
              title: "我的订单",
              name: "/myordermag"
            });
          } else {
            that.$root.pushx({
              title: "我的订单",
              name: "/myorder"
            });
          }
        }
      }).catch(e=>{
        if (that.isBizemp) {
          that.$root.pushx({
            title: "我的订单",
            name: "/myordermag"
          });
        } else {
          that.$root.pushx({
            title: "我的订单",
            name: "/myorder"
          });
        }
      });
    },
    bankchange(d){
      var account = this.accounts[d];
      console.log(account);
      if (account) {
        this.accountinfo = account;
        this.account_id = account.id;
      }
    },
    copyLink(){
      var oInput = document.createElement('input');
      oInput.value = "https://igirl.gongsibao.com/orderpay/orderpay?state=" + this.orderNum;
      document.body.appendChild(oInput);
      oInput.select();
      document.execCommand("Copy");
      oInput.className = 'oInput';
      oInput.style.display = 'none';
      this.$message({
        type: 'success',
        message: '复制成功'
      });
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    setKey(name, flag){
      console.log(name);
      console.log(flag);
      name = name.substring(name.length - 5);
      var myDate = new Date();
      var key = "zc_" + Math.round(Math.random() * 500) + myDate.getMonth() + myDate.getTime() + myDate.getFullYear() + myDate.getDate() + myDate.getHours() + myDate.getMinutes() + myDate.getSeconds() + myDate.getMilliseconds() + name.replace(" ", "");
      console.log(this.$refs[flag]);
      this.$refs[flag].d.key = key;
    },
    uploadsuccess2(result, obj){
      this.zfpzUrl = result;
      this.payOrderType = true;
    },
    toOfflinePay(){
      this.payType = "offline";
      this.closePayConfirm();
    },
    toOtherPeoplePay(){
      this.payType = "otherPeople";
      this.closePayConfirm();
    },
    offlinePaySubmit(){
      var that = this;
      var fileUrl = this.zfpzUrl;
      var orderNum = this.orderNum;
      var account_id = this.account_id;
      if (!fileUrl) {
        that.$message.warning("请上传支付凭证");
        return;
      }
      if (!account_id) {
        that.$message.warning("请选择付款账户");
        return;
      }
      if (orderNum) {
        var obj = {
          fileUrl: fileUrl,
          orderNum: orderNum,
          account_id: account_id,
        };
        this.$root.showMask();
        this.$root.getReq("/web/orderCtl/offlinePay", obj).then(function (d) {
          if (d && d.code == 1) {
            that.$message.success("支付成功");
            that.afterpayjump();
            /** if (that.isBizemp) {
              that.$root.pushx({
                title: "我的订单",
                name: "/myordermag"
              });
            } else {
              that.$root.pushx({
                title: "我的订单",
                name: "/myorder"
              });
            }*/
          } else {
            that.$message.warning(d.msg);
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.$message.warning("操作失败");
          that.$root.hideMask();
        })
      } else {
        that.$message.warning("参数错误");
      }
    },
    toWxPay(){
      this.payType = "wx";
      this.closePayConfirm();
      this.getPayQrCode();
    },
    toAliPay(){
      this.payType = "alipay";
      this.closePayConfirm();
      this.getPayQrCode();
    },
    getPayQrCode: function() {
      var self = this;
      if (!this.orderInfo || !this.orderInfo.code) {
        this.$message.warning(`获取支付码失败，订单信息有误`);
        return;
      }
      self.loading = true;
      self.$root.postReq("/web/orderCtl/getQrCodeTl", { code: this.orderInfo.code, company_id: this.orderInfo.company_id, op_type: this.payType }).then(d => {
        console.log(d, "getQrCode........................");
        if (d && d.code == 1) {
          var data = d.data;
          self.qrcode = "http://bigdata.gongsibao.com/api/qc?detailLink=" + encodeURIComponent(data.payinfo);
          self.orderInfo.wxPayOrderCode = data.wxPayOrderCode;
          self.orderInfo.aliPayOrderCode = data.aliPayOrderCode;
          self.time = new Date().getTime();
          self.checkOrderStatus();
        } else {
          self.$message.warning(d.msg);
        }
        self.loading = false;
      }).catch(e => {
        self.$message.warning(`获取支付码失败`);
        self.loading = false;
      });
    },
    closePayConfirm(){
      if (this.interval) {
        window.clearInterval(this.interval);
      }
    },
    checkOrderStatus(){
      var self = this;
      var startTime = Number(this.time);
      setTimeout(function () {
        var inth = setInterval(function () {
          self.$root.postReq("/web/orderCtl/findItemByCodeTl", { orderCode: self.orderInfo.code, wxPayOrderCode: self.orderInfo.wxPayOrderCode, aliPayOrderCode: self.orderInfo.aliPayOrderCode, company_id: self.orderInfo.company_id, sub_type: self.orderInfo.subType, op_type: self.payType }).then(d => {
            if (d && d.code == 1 && d.data && d.data.orderPayStatus == "yfk") {
              self.orderInfo = d.data;
              window.clearInterval(inth);
              self.$message.success("付款成功");
              self.afterpayjump();
              /**if (self.isBizemp) {
                self.$root.pushx({
                  title: "我的订单",
                  name: "/myordermag"
                });
              } else {
                self.$root.pushx({
                  title: "我的订单",
                  name: "/myorder"
                });
              } */
              return;
            } else {
              var passTime = (new Date().getTime() - startTime) / 1000;
              var p = Math.round((passTime / 300) * 100);
              if (passTime > 300) {
                clearInterval(inth);
              }
            }
          });
        }, 5000);
        self.interval = inth;
      }, 5000);
    },
  },
  vname: "gsb_orderpay"
}
