{
  template: '${tmpl}',
    data: function() {
      return {
        sumparams: ["totalSum"],
        multipleSelection: [],
        isSingleSelect: false,
        sfs: [{ field: 'totalSum', label: '收款总金额' }],
      }
    },
  mounted: function() {

  },
  created: function() {
  },
  methods: {
    btnvisbleMethod(row, btn){
      if (btn.key == "linkquery") {
        if (!row.sourceOrderNo || row.sourceOrderNo == "") {
          return false;
        } else {
          if (row.sveItemCode != "dlrfzzc" && row.sveItemCode != "zzsbzc" && row.sveItemCode != "dbsbzc") {
            return false;
          }
          return true;
        }
      }
      else if (btn.key == "queryPayVoucher") {
        return !(!row.certifyFileUrl || row.certifyFileUrl == "");
      }
      return true;
    },
    onlinkquery(row){
      this.$root.postReq("/web/orderCtl/findOne", { "code": row.sourceOrderNo }).then(d => {
        if (d.code == 1 && d.data) {
          if (d.data.sveItemCode != "dlrfzzc" && d.data.sveItemCode != "zzsbzc" && d.data.sveItemCode != "dbsbzc") {
            this.$message.warning(`目前只支持【自助商标注册、代理人辅助注册、担保商标注册】的连查订单!`);
          } else {
            this.$root.pushx({
              title: "订单详情",
              name: "/tmOrderDetail",
              params: {
                orderNum: row.sourceOrderNo,
              }
            });
          }
        } else {
          this.$message.warning(`没有找到相关订单信息!`);
        }
      });

    },
    onColFormater(row, column, cellvalue, index){
      if (column.property == "created_at") {
        var date = new Date(row["created_at"]);
        var time = date.toLocaleDateString();
        return time;
      }
      if (column.property == "updated_at") {
        var date = new Date(row["updated_at"]);
        var time = date.toLocaleDateString();
        return time;
      }
      if (column.property == "payOrderNo") {
        if (!row["payOrderNo"]) {
          return "---";
        } else {
          return row.payOrderNo;
        }
      }
      if (column.property == "notes") {
        if (!row["notes"]) {
          return "---";
        } else {
          return row.notes;
        }
      }
      if (column.property == "opNotes") {
        if (!row["opNotes"]) {
          return "---";
        } else {
          return row.opNotes;
        }
      }
      if (column.property == "sourceOrderNo") {
        if (!row["sourceOrderNo"]) {
          return "---";
        } else {
          return row.sourceOrderNo;
        }
      }
      if (column.property == "auditor") {
        if (!row["auditor"]) {
          return "---";
        } else {
          return row.auditor;
        }
      }
      if (column.property == "sveItemName") {
        if (!row["sveItemName"]) {
          return "---";
        } else {
          return row.sveItemName;
        }
      }
      return cellvalue;
    },
    handleSelectionChange: function(val) {
      this.multipleSelection = val;
      console.log(val);
    },
    onRowClick(row, key, e){
      if (key == "queryPayVoucher") {
        if (row.certifyFileUrl) {
          window.open(row.certifyFileUrl);
        } else {
          this.$message.warning(`暂无支付凭证!`);
        }
      }
    },
  },
  computed: Vuex.mapState({
    count: state => state.count,
    headStyle: function () {
      return { "background-color": "white" };
    }
  }),
    vname: "gsb_receiptvoucher"
}
