{
  template: '${tmpl}',
    data: function() {
      var codeValidator = (rule, value, callback) => {
        if (!value || value.toString().length!=18) {
          callback(new Error('请输入18位正确的统一社会信用代码!'));
        } else {
          callback();
        }
      };
      var mobileValidator = (rule, value, callback) => {
        var x = /((\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$)/g.test(value);
        if (!x) {
          callback(new Error('联系电话格式错误！'));
        } else {
          callback();
        }
      };
      var emailValidator = (rule, value, callback) => {
        var x = /^([a-zA-Z0-9._-])+@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-])+/.test(value);
        if (!x) {
          callback(new Error('电子邮箱格式错误！'));
        } else {
          callback();
        }
      };
      return {
        apply: {
          name: "",
          code: "",
          customerType:"",
          customerName:"",
          credentialsType:"",
          legalRepresentativeCertificateNo: "",
          legalRepresentativeCertificatePic:"",
          businessLicensePic:"",
          mobile: "",
          email: "",
          applyAddr:"",
          contacts:"",
          valueAddedTelecomBusinessApplicationForm:"",
          naturalPersonShareholderIdCard:"",
          trusteeshipAgreementAndIDC:"",
          domainNameCertificate:"",
          paymentAgreementAndLicense:"",
          capitalFlowDesAndMerchantPresenceTemp:""
        },
        applyrules: {
          customerType: [
            { type: 'string', required: true, message: '请选择法人类型！', trigger: 'change' }
          ],
          credentialsType: [
            { type: 'string', required: true, message: '请先选择法定代表人证件类型！', trigger: 'change' }
          ],
          name: [
            { required: true,trigger: 'blur', message: '法人企业或机构名称不能为空！' }
          ],
          code: [
            { required: true, message: '请输入18位正确的统一社会信用代码!' },
            { validator: codeValidator, trigger: 'blur' }
          ],
          customerName:[
            { required: true, message: '法定代表人姓名不能为空！' },
          ],
          legalRepresentativeCertificateNo: [
            { required: true, message: '企业法定代表人证件号不能为空！' },
          ],
          contacts:[
            { required: true, message: '请填写联系人！' }
          ],
          applyAddr: [
            { required: true, message: '请填写执照详细地址！' }
          ],
          mobile: [
            { required: true, message: '请填写联系电话！' },
            { validator: mobileValidator, trigger: 'blur' }
          ],
          email: [
            { required: true, message: '请填写电子邮箱！' },
            { validator: emailValidator, trigger: 'blur' }
          ],
          legalRepresentativeCertificatePic:[
            { required: true, message: '请上传身份证件扫描件！' }
          ],
          businessLicensePic:[
            { required: true, message: '请上传营业执照扫描件！' }
          ]
        },
        d: {},
        action: "",
        order: {},
        loading: false,
        loading1: false,
        loading2: false,
        loading3: false,
        toViewImgKey: null,
        toViewImgType: false,
        toViewImgSrc: null,
        itemCode:"CP201910231025EaQM0b",
        serviceitem:null,
        price:'未知',
        step:1
      }
    },
  computed: Vuex.mapState({
    count: state => state.count,
    headStyle: function () {
      return { "background-color": "white" };
    }
  }),
  created: function() {
    var that = this;
    var apply = this.$router.history.current.query.apply;
    if (apply) {
        this.apply = apply;
    }
    var company = this.$root.currentCompany;
    if (company && company.companyType == "self") {
      this.company = company;
    } else {
      this.$root.getReq("/web/companyCtl/findById", { cid: 1 }).then(function (d) {
        if (d && d.status == 0 && d.data) {
          that.company = d.data
        }
      });
    }

  },
  mounted: function() {
    var that = this;
    that.toTop();
    this.getServiceItem();
    this.$root.postReq("/web/uploadCtl/getOssConfig", "").then(function (d) {
      that.d["key"] = "key";
      that.d["Bucket"] = d.Bucket;
      that.d["OSSAccessKeyId"] = d.OSSAccessKeyId;
      that.d["Signature"] = d.Signature;
      that.d["policy"] = d.policy;
      that.d["success_action_status"] = d.success_action_status;
      that.action = d.url;
    });
  },
  methods: {
    openUrl(flag){
      var that = this;
      if (flag == "yyzz") {
        window.open(that.apply["businessLicensePic"]);
      }
      if (flag == "zzdxywsqb") {
        window.open(that.apply["valueAddedTelecomBusinessApplicationForm"]);
      }
      if (flag == "frsfz") {
        window.open(that.apply["legalRepresentativeCertificatePic"]);
      }
      if (flag == "zrrgdsfz") {
        window.open(that.apply["naturalPersonShareholderIdCard"]);
      }
      if (flag == "tgxyidc") {
        window.open(that.apply["trusteeshipAgreementAndIDC"]);
      }
      if (flag == "ymzs") {
        window.open(that.apply["domainNameCertificate"]);
      }
      if (flag == "zfxypz") {
        window.open(that.apply["paymentAgreementAndLicense"]);
      }
      if (flag == "zjlxsmsjrzmb") {
        window.open(that.apply["capitalFlowDesAndMerchantPresenceTemp"]);
      }
    },
    nextStep(){
      var that = this;
      this.$refs["apply"].validate((valid) => {
        if (valid) {
          this.step=2;
        }
      });
      
    },
    beforeStep(){
      this.step=1;
    },
    pointsRuleColor(i) {
      if (i < parseInt(this.step)) {
        return 'color: #535353;'
      } else if (i == parseInt(this.step)) {
        return 'color: #FFFFFF;'
      } else if (i > parseInt(this.step)) {
        return 'color: #535353;'
      }
    },
    pointsRuleBackColor(i) {
      if (i < parseInt(this.step)) {
        return 'background: #D8EDFB;z-index: ' + Math.abs(i - 5)
      } else if (i == parseInt(this.step)) {
        return 'background: #0F8EE9;z-index: ' + Math.abs(i - 5)
      } else if (i > parseInt(this.step)) {
        return 'background: #EDEDED;z-index: ' + Math.abs(i - 5)
      }
    },
    toViewImg(src) {
      this.toViewImgSrc = src;
      this.toViewImgType = true
    },
    mouseOverDemo(v, k) {
      if (v == 99) {
        this.floatBoxDemo = true
      } else {
        if (k) {
          this.toViewImgKey = k
        } else {
          this.toViewImgKey = v
        }
      }
    },
    mouseLeaveDemo(v) {
      this.floatBoxDemo = false;
      this.toViewImgKey = null
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    uploadsuccess(obj){
      console.log(obj, "bbbbbbbbbbbbbbbbbbbbbbbbbbb");
      var that = this;
      if (this.loadingKey == 1) {
        that.loading1 = true;
      } else if (this.loadingKey == 2) {
        that.loading2 = true;
      } else if (this.loadingKey == 3) {
        that.loading3 = true;
      } else if (this.loadingKey == 0) {
        that.loading = true;
      }
      if (obj.flag == "yyzz") {
        that.apply["businessLicensePic"] = obj.result;
      }
      if (obj.flag == "zjsmj") {
        that.apply["legalRepresentativeCertificatePic"] = obj.result;
      }
      if (obj.flag == "zzdxywsqb") {
        that.apply["valueAddedTelecomBusinessApplicationForm"] = obj.result;
      }
      if (obj.flag == "frsfz") {
        that.apply["legalRepresentativeCertificatePic"] = obj.result;
      }
      if (obj.flag == "zrrgdsfz") {
        that.apply["naturalPersonShareholderIdCard"] = obj.result;
      }
      if (obj.flag == "tgxyidc") {
        that.apply["trusteeshipAgreementAndIDC"] = obj.result;
      }
      if (obj.flag == "ymzs") {
        that.apply["domainNameCertificate"] = obj.result;
      }
      if (obj.flag == "zfxypz") {
        that.apply["paymentAgreementAndLicense"] = obj.result;
      }
      if (obj.flag == "zjlxsmsjrzmb") {
        that.apply["capitalFlowDesAndMerchantPresenceTemp"] = obj.result;
      }
    },
    beforeUpload(file){
      var that = this;
      var isSize = false;
      var img = new Image();
      var _URL = window.URL || window.webkitURL;
      img.onload = function () {
        if (img.width == img.height) {
          isSize = true;
          that.$refs.ys_upload.ifupload = true;
        } else {
          isSize = false;
          that.$message.warning('上传的图片宽高必须相等');
          that.$refs.ys_upload.$refs.upload.abort(file);
        }
      };
      img.src = window.URL.createObjectURL(file);

    },
    getServiceItem(){
      var itemCode = this.itemCode;
      var that = this;
      if (itemCode) {
        this.$root.getReq("/web/serviceitemCtl/findOneByCode", { code: itemCode }).then(function (d) {
          if (d && d.code == 1 && d.data.isPubed) {
            var data = d.data;
            that.serviceitem = data;
            that.price = data.price || '未知'
          } else {
            that.$message.warning(d.msg);
          }
        }).catch(function (e) {
          that.$message.warning("获取产品失败");
        })
      } else {
        this.$message.warning('code参数错误');
        return;
      }
    },
    submitForm() {
      var that = this;
      this.$refs["apply"].validate((valid) => {
        if (valid) {
          if(this.serviceitem && this.serviceitem.id){
            var icpobj = {itemCode:this.itemCode,apply:this.apply,price:this.price};
            if (!this.currentUser) {
              localStorage.setItem("afterLogin", JSON.stringify({
                title: "ICP注册",
                name: "/selficpreg",
                params: {apply: this.apply }
              }));
              this.$root.pushx({
                title: "登录",
                name: "/login"
              });
              return false;
            }
            that.$root.postReq("/web/orderCtl/createIcpOrder", icpobj).then(function (d) {
              if (d.code == "1") {
                var order = d.data;
                that.toTop();
                that.$message.warning("订单提交成功");
                that.$root.pushx({
                  title: "订单支付",
                  name: "/orderpay",
                  params: {
                    orderNum: order.code
                  }
                });
              } else {
                that.$message.warning(d.msg);
              }
              that.$root.hideMask();
            }).catch(function (e) {
              that.$message.warning("操作失败");
              that.$root.hideMask();
            });
          }else{
            that.$message.warning("未知产品");
            return false;
          }
        } else {
          console.log('error submit!!');
          return false;
        }
      });
    },
    applierChange(){
      this.$root.getReq("/web/toolCtl/getEntregistryByCompanyName", { companyName: this.apply.name }).then(d => {
        if (d.creditCode && d.creditCode != "") {
          this.apply.applyAddr = d.businessAddress;
          this.apply.code = d.creditCode;
        }
      });
    },
    setKey(name, flag){
      console.log("setKey+++++++++++++++++++++++++++");
      console.log(name);
      console.log(flag);
      name = name.substring(name.length - 5);
      var myDate = new Date();
      var key = "zc_" + flag + Math.round(Math.random() * 10000) + myDate.getTime() + myDate.getFullYear() + myDate.getMonth() + myDate.getDate() + name;

      this.$refs[flag].d.key = key;
    },
    toTop(){
      $('#app').animate({ scrollTop: 0 }, 10);
    },
  },

  vname: "gsb-selficpreg"
}
