{
    template:'${tmpl}',
    data:function(){
      var that=this;
      var validatePrice=function(rule, value, callback){
        console.log(that.multipleSelection);
        console.log(value);
        console.log(value);
        for(var i=0;i<that.multipleSelection.length;i++){
          var d = that.multipleSelection[i];
          if(!d.price && !value){
            return  callback(new Error("请填写批量设置价格或补全列表已选商标的发布价格"));
          }
        }
        return callback();
      };
        return {
          lawstatus:{1:"有效",2:"无效",3:"待审",4:"不定",5:"未知"},
          form:{
            type:"applier",
            value:"",
          },
          tm:{
            price:"",
            contacts:"",
            mobile:"",
          },
          rules:{
            contacts:[
              { required: true, message: '请输入联系人', trigger: 'blur' },
            ],
            mobile:[
              { required: true, message: '请输入联系电话', trigger: 'blur' },
            ],
            price:[
              { validator: validatePrice, trigger: 'blur' },
            ]
          },
          count:0,
          exportExcelUrl:"",
          d:{},
          action:"",
          loading:false,
          currentPage: 1,
          pageSize:10,
          tableData: [
            
          ],
          multipleSelection: [],
          selectedIndex:-1,
          showLargePic:false,
          largePicUrl:"",
          entList:[],
          
        }
    },
    mounted:function(){
      var that=this;
      this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
        that.d["key"]="key";
        that.d["Bucket"]=d.Bucket;
        that.d["OSSAccessKeyId"]=d.OSSAccessKeyId;
        that.d["Signature"]=d.Signature;
        that.d["policy"]=d.policy;
        that.d["success_action_status"]=d.success_action_status;
        that.action=d.url;
    });
    },
    created:function(){

    },
    methods:{
      selectent:function(likestr){
        this.$root.postReq("/web/toolCtl/getCompanyInfoByLikeName",{fields:["entName"],likestr:likestr}).then(d=>{
             this.entList=[];
             if(d && d.data){
               this.entList=d.data;
             }
        });
      },
      headerCellStyle:function(){
        return {
                "background-color": "#F5F5F5",
                "color": "#2F2F2F",
                "font-size": "14px",
                "font-weight":"400"
        };
      },
      toBatchRelease(){
        this.$root.pushx({
          title:"批量发布交易商标",
          name:"/tmtransactionbatchrelease"
         });
         return;
      },
      changepic(scope){
        console.log(scope);
        this.selectedIndex = "";
        if(scope && scope.row){
          this.selectedIndex = scope.$index;
          this.showLargePic=true;
          this.largePicUrl=scope.row.pic_url;
        }

        
      },
      showLargeTm(url){
        if(url){
            this.showLargePic=true;
            this.largePicUrl=url;
        }
      },
      toggleSelection(rows) {
        if (rows) {
          rows.forEach(row => {
            this.$refs.multipleTable.toggleRowSelection(row);
          });
        } else {
          this.$refs.multipleTable.clearSelection();
        }
      },
      handleSelectionChange(val) {
        this.multipleSelection = val;
        console.log(val);
      },
      handleSizeChange(val) {
        if(this.pageSize!=val){
          this.pageSize=val;
          console.log(`每页 ${val} 条`);
          console.log(this.pageSize);
          this.fetchData();
        }
        
      },
      handleCurrentChange(val) {
        if(this.currentPage!=val){
          this.currentPage=val;
          console.log(`当前页: ${val}`);
          console.log(this.currentPage);
          this.fetchData();
        }
        
      },
      fetchData(){
        var value = this.form.value;
        this.form.value=value.replace(/(^\s*)|(\s*$)/g, "");
        if(!this.form.value){
          this.$message.warning("请输入申请人或申请号查询商标");
          return;
        }
        if(this.form.type=="applier"){
          var obj={
            applicant_cn:this.form.value,page_size:this.pageSize,current_page:this.currentPage
          };
          this.$root.showMask();
          this.$root.getReq("web/trademarktransactionCtl/fetchDataByApplier",obj).then(d=>{
            console.log(d);
            if(d && d.code==1){
              for(var i=0;i<d.data.length;i++){
                if(d.data[i].status){
                  d.data[i].status = this.lawstatus[d.data[i].status];
                }
              }
              this.tableData=d.data;
              this.count=d.count;
            }
            this.$root.hideMask();
          }).catch(e=>{
            this.$root.hideMask();
          })
        }
        if(this.form.type=="code"){
          var numList = this.form.value.split(" ");
          var obj={
            registNums:numList,page_size:this.pageSize,current_page:this.currentPage
          };
          console.log(obj);
          this.$root.showMask();
          this.$root.getReq("web/trademarktransactionCtl/fetchDataByRegistNums",obj).then(d=>{
            console.log(d);
            if(d && d.code==1){
              for(var i=0;i<d.data.length;i++){
                if(d.data[i].status){
                  d.data[i].status = this.lawstatus[d.data[i].status];
                }
              }
              this.tableData=d.data;
              this.count=d.count;
            }
            this.$root.hideMask();
          }).catch(e=>{
            this.$root.hideMask();
          })
        }
      },
      setKey(name,flag){
        var myDate = new Date();
        var key = "zc_sbjy"+Math.round(Math.random()*10000)+myDate.getMonth()+myDate.getTime()+myDate.getFullYear()+myDate.getDate()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+".xlsx";
        console.log(this.$refs[flag]);
        this.$refs[flag].d.key = key;
      },
      uploadsuccess(obj){
        var that = this;
        that.loading = true;
        this.largePicUrl = obj.result;
        setTimeout(() => {
          that.loading = false;
        }, 1000);
        return
      },
      useMyPic(){
        if(this.selectedIndex>=0){
          this.$confirm('此操作将替换表格中商标图样, 是否继续?', '提示', {
            confirmButtonText: '确定',
            cancelButtonText: '取消',
            type: 'warning'
          }).then(() => {
            this.tableData[this.selectedIndex].pic_url = this.largePicUrl;
            this.$message.success("图样替换成功");
            this.showLargePic=false;
          })
         
        }
      },
      error(err){
        this.$message.warning(`上传失败，请重新上传`);
        console.log(err);
      },
      toList(){
        this.$root.pushx({
          title:"商标交易库",
          name:"/mytmtransaction"
         });
         return;
      },
      publish(){
        var that = this;
        if(!this.multipleSelection || this.multipleSelection.length<1){
          this.$message.warning("请至少选择一条商标数据");
          return;
        }
        this.$refs.tm.validate((valid) => {
          if (valid) {
            this.$confirm('此操作将发布已选商标, 是否继续?', '提示', {
              confirmButtonText: '确定',
              cancelButtonText: '取消',
              type: 'warning'
            }).then(() => {
              var datalist = this.multipleSelection;
              for(var i=0;i<datalist.length;i++){
                if(!datalist[i].price){
                  datalist[i].price=that.tm.price;
                }
              }
              var obj={tms:datalist,contacts:that.tm.contacts,mobile:that.tm.mobile};
              console.log(obj);
              this.$root.showMask();
              this.$root.postReq("web/trademarktransactionCtl/publishApplierTm",obj).then(d=>{
                if(d && d.code==1){
                  that.exportExcelUrl=d.exportExcelUrl;
                  that.$message.success("发布完成，共发布"+d.sum+"个商标，成功"+d.successCount+"个，失败"+d.errorCount+"个");
                }else{
                  that.$message.warning(d.msg);
                }
                this.$root.hideMask();
              }).catch(e=>{
                this.$root.hideMask();
              })
            }).catch(() => {
                     
            });

          } else {
            return false;
          }
        });
      }
    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    vname:"gsb_tmtransactionentrelease"
}
