{
    template:'${tmpl}',
    data:function(){
      var validateMobile = (rule, value, callback) =>{
        if(value==""){
          callback(new Error('请输入您的联系电话'));
        }else{
          var x=(/^1(3|4|5|7|8)\d{9}$/.test(value));
          if(!x){
            callback(new Error('手机号码格式有误'));
          }else{
            callback();
          }
        }
      };
        return {
          bgcolor: '#fff',
          hotcolor: '#999',
          trademarkInput:'',
          trademarkMin: '',
          trademarkMax: '',
          min:'',
          max:'',
          navarr:[
            '服装',
            '互联网',
            '日化品',
            '酒水',
            '食品',
            '教育培训',
            '广告营销'
          ],
          ncldata:[
            {},
            {code:"01",name:"化学原料",type:1},{code:"02",name:"颜料油漆",type:1},{code:"03",name:"日化用品",type:1},{code:"04",name:"燃料油脂",type:1},{code:"05",name:"医用药品",type:1},
            {code:"06",name:"金属材料",type:1},{code:"07",name:"机械设备",type:1},{code:"08",name:"手工器械",type:1},{code:"09",name:"科学仪器",type:1},{code:"10",name:"医疗器械",type:1},
            {code:"11",name:"灯具空调",type:1},{code:"12",name:"运输工具",type:1},{code:"13",name:"军火烟火",type:1},{code:"14",name:"珠宝钟表",type:1},{code:"15",name:"音乐器材",type:1},
            {code:"16",name:"办公用品",type:1},{code:"17",name:"橡胶制品",type:1},{code:"18",name:"皮革皮具",type:1},{code:"19",name:"建筑材料",type:1},{code:"20",name:"家具用品",type:1},
            {code:"21",name:"厨房洁具",type:1},{code:"22",name:"绳网袋篷",type:1},{code:"23",name:"纺织纱线",type:1},{code:"24",name:"布料床单",type:1},{code:"25",name:"服装鞋帽",type:1},
            {code:"26",name:"纽扣拉链",type:1},{code:"27",name:"地毯席垫",type:1},{code:"28",name:"健身器材",type:1},{code:"29",name:"肉食蜜饯",type:1},{code:"30",name:"方便食品",type:1},
            {code:"31",name:"饲料种籽",type:1},{code:"32",name:"啤酒饮料",type:1},{code:"33",name:"酒精饮料",type:1},{code:"34",name:"烟草烟具",type:1},{code:"35",name:"广告销售",type:1},
            {code:"36",name:"金融物管",type:1},{code:"37",name:"建筑修理",type:1},{code:"38",name:"通讯服务",type:1},{code:"39",name:"运输贮藏",type:1},{code:"40",name:"材料加工",type:1},
            {code:"41",name:"教育娱乐",type:1},{code:"42",name:"网站服务",type:1},{code:"43",name:"餐饮住宿",type:1},{code:"44",name:"医疗园艺",type:1},{code:"45",name:"社会服务",type:1}
          ],
          trademarkPriceArr:[
            '不限',
            '1万以下',
            '1-2万',
            '2-5万',
            '5-8万',
            '8-15万',
            '15万以上'
          ],
          trademarkStructureArr:[
            '不限',
            '纯中文',
            '中文+英文',
            '纯图形',
            '中文+图形',
            '英文+图形',
            '纯英文',
            '中文+英文+图形'
          ],
          trademarkNumberArr:[
            '不限',
            '1-2个字',
            '3个字',
            '4个字',
            '5个字',
            '5个字以上',
          ],
          trademarkSortingArr: [
            {name:'价格',type:false},
            {name:'时间',type:false}  
          ],
          currentpage:1,
          trademarkData:[],
          trademarkSort: '',
          trademarkPriceKey: 0,
          trademarkPriceName:'',
          trademarkStructureKey: 0,
          trademarkStructureName: '',
          trademarkNumberKey: 0,
          trademarkNumberName:'',
          trademarkDataKeyArr: [99],
          trademarkDataCoder: [],
          trademarkSortingKeyArr: [],
          trademarkSortingType:true,
          trademarkSortingName: '',
          trademarkHeight: 'height:28px;',
          trademarkType: false,
          selectedConditionArr:[],
          dialogTableVisible:false,
          total:0,
          tmdetail:{},
          spfwxm:"",
          form:{
            price:"",
            name:"",
            mobile:""
          },
          rules:{
            price: [
              { required: true, message: '请输入您的预算价格', trigger: 'blur' }
            ],
            name: [
              { required: true, message: '请输入您的姓名', trigger: 'blur' }
            ],
            mobile: [
              { required: true,validator: validateMobile, trigger: 'blur' }
            ],
          },
          bannerImg:'',
          loading: false,
          noMore: false
        }
    },
    mounted:function(){
      $('#app').scrollTop(0);
      var trademarkName = this.$router.history.current.query.trademarkName || localStorage.getItem("trademarkName");
      if (trademarkName) {
        this.trademarkHot(trademarkName)
      }else {
        this.trademarkInput = this.$router.history.current.query.tminput || '';
        this.trademarkDataKeyArr = this.$router.history.current.query.trademarkCode ? this.$router.history.current.query.trademarkCode.split(',').map(Number) : [99];
        this.bannerImg = this.$router.history.current.query.trademarkImg || this.bannerImg;
        this.bgcolor = this.$router.history.current.query.trademarkColor || this.bgcolor;
        this.hotcolor = this.$router.history.current.query.trademarkTextColor || this.hotcolor;
        this.selectedConditionArr = [];
        if (this.$router.history.current.query.trademarkCode) {
          for (let i = 0; i < this.trademarkDataKeyArr.length; i++) {
            this.selectedConditionArr.push(this.ncldata[this.trademarkDataKeyArr[i]].name)  
          }
        }
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      };
      var timers = null;
      var that = this;
      $('#app').scroll(function() {
        if (($(this)[0].scrollTop + $(this).height() + 60) >= $(this)[0].scrollHeight) {
            clearTimeout(timers);
            if (that.total/30 > that.currentpage) {
              var this_ = that;
              that.noMore = false;
              timers = setTimeout(function() {
                this_.currentpage++;
                console.log("第" + this_.currentpage + "页");
                this_.loading = true;
                this_.trademarkPost();
              }, 300);
            }else {
              that.loading = false;
              that.noMore = true;
            }
            
        }
      })
    },
    created:function(){
      document.getElementsByTagName("title")[0].innerText = '商标交易';
    },
    methods:{
      exportList(){
        this.$confirm('此操作将导出商标列表数据, 是否继续?', '提示', {
            confirmButtonText: '确定',
            cancelButtonText: '取消',
            type: 'warning'
          }).then(() => {
            this.tableToExcel();
          }).catch((e)=>{
            console.log(e);
              this.$message({
                type: 'info',
                message: '已取消导出'
              });
          });
        
      },
      tableToExcel(){
        var jsonData = this.trademarkData;
        console.log(jsonData);
        var str = "<tr><td>商标图片</td><td>商标名称</td><td>价格</td><td>尼斯类别</td></tr>";
        for(var i = 0 ; i < jsonData.length ; i++ ){
          str+='<tr>';
          var jdata = jsonData[i];
          str+="<td>"+jdata.pic_url+"</td>"; 
          str+="<td>"+jdata.tm_name+"</td>"; 
          str+="<td>"+jdata.platform_quoted_price+"</td>"; 
          str+="<td>"+jdata.ncl_one_codes_name+"</td>";   
          str+="</tr>";
        }
        var worksheet = "Sheet1";
        var uri = 'data:application/vnd.ms-excel;base64,';
  
        var template = "<html xmlns:o=\'urn:schemas-microsoft-com:office:office\' xmlns:x=\'urn:schemas-microsoft-com:office:excel\' xmlns=\'http://www.w3.org/TR/REC-html40\'>"+
        "<head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>"+worksheet+"</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet>"+
        "</x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>"+str+"</table></body></html>";
        var oa = document.getElementById("grid2_export");
        console.log(uri);
        console.log(this.base64(template));
        oa.href = uri + this.base64(template);
        oa.download = "商标交易.xls";
        oa.click();
        oa.style.display='none';
      },
      base64 (s) { 
        return window.btoa(unescape(encodeURIComponent(s)));
      },
      toDetail(sbzch,gjfl){
        if(sbzch && gjfl){
          this.$root.windowOpen({
            url:window.location.href.split("#")[0]+"#/tmtransactiondetail",
            title:"商标详情",
            params:[
              {name:"sbzch",value: sbzch},
              {name:"gjfl",value: gjfl}
            ]
          })
        }
      },
      handleCurrentChange(val){
        this.currentpage=val;
        this.trademarkPost();
      },
      submitNeed(){
        var that=this;
        this.$refs.form.validate((valid) => {
          if (valid) {
            var obj={
              code:this.tmdetail.tm_regist_num,
              buyer_name:this.form.name,
              buyer_mobile:this.form.mobile,
              buyer_quoted_price:this.form.price
            };
            console.log(obj);
            this.$root.postReq("web/trademarktransactionneedCtl/submitNeed", obj).then(function (d) {
              that.dialogTableVisible =false;
              if(d.code==1){
                that.$message.success("提交报价成功");
              }else{
                that.$message.warning(d.msg);
              }
            }).catch(e=>{
              that.$message.warning("操作失败");
            })
          }
        })
      },
      open(index){
        var that=this;
        this.tmdetail=index;
        var obj={
          sbzch:index.tm_regist_num,
          gjfl:index.ncl_one_codes
        };
        this.$root.postReq("/web/trademarktransactionCtl/tmTransactionDetail", obj).then(function (d) {
          if(d.status==0){
            that.spfwxm=d.data.detail.spfwxm;
          }else{
            that.spfwxm="";
          }
          that.dialogTableVisible =true;
        })
          
      },
      trademarkSearch(){
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      trademarkPost() {
        localStorage.removeItem("trademarkName");
        var that=this;
        var nclcode=[];
        if(this.selectedConditionArr.length != 0){
            for(var i=0;i<this.trademarkDataKeyArr.length;i++){
                nclcode.push(this.trademarkDataKeyArr[i]);
            }
        }
        var obj = {
          keyword: this.trademarkInput,
          tm_nclcode: nclcode,
          /*tm_price: this.trademarkPriceName,*/
          min:this.min,
          max:this.max,
          tm_structure: this.trademarkStructureName,
          tm_word: this.trademarkNumberName,
          order: this.trademarkSortingName,
          sort: this.trademarkSort,
          pagesize:36,
          currentpage:this.currentpage
        };
        var loading = null;
        if (this.currentpage == 1) {
          loading = that.$loading({
            lock: true,
            text: 'Loading',
            spinner: 'el-icon-loading',
            background: 'rgba(0, 0, 0, 0.7)'
          });
        };
        this.$root.postReq("/web/trademarktransactionCtl/tmTransactionSearch", obj).then(function (d) {
          loading && loading.close();
          this.loading = false;
          if(d.status == 0 && d.data.total != 0){
            that.total =d.data.total;
            for (let index = 0; index < d.data.rows.length; index++) {
              that.trademarkData.push(d.data.rows[index])
            }
            /*that.trademarkData=d.data.rows;*/
          }else{
            that.total=0;
            that.trademarkData=[];
          }
        })
      },
      trademarkHot (name) {
        /*this.trademarkInput = name;*/
        switch(name){
          case '影视':
            this.trademarkDataKeyArr = [35,41];
            break;
          case '服装':
            this.trademarkDataKeyArr = [25];
            break;
          case '互联网':
            this.trademarkDataKeyArr = [9,38,42];
            break;
          case '日化品':
            this.trademarkDataKeyArr = [3];
            break;
          case '酒水':
            this.trademarkDataKeyArr = [32,33];
            break;
          case '食品':
            this.trademarkDataKeyArr = [29,30];
            break;
          case '教育培训':
            this.trademarkDataKeyArr = [41];
            break;
          case '广告营销':
            this.trademarkDataKeyArr = [35];
            break;
          case '（25类）服装鞋帽':
            this.trademarkDataKeyArr = [25];
            break;
          case '（03类）日化用品':
            this.trademarkDataKeyArr = [3];
            break;
          case '（30类）方便食品':
            this.trademarkDataKeyArr = [30];
            break;
          case '（29类）食品':
            this.trademarkDataKeyArr = [29];
            break;
          case '（09类）科学仪器':
            this.trademarkDataKeyArr = [9];
            break;
          case '（36类）金融物管':
            this.trademarkDataKeyArr = [36];
            break;
          case '（35类）广告营销':
            this.trademarkDataKeyArr = [35];
            break;
          case '全部类别':
            this.trademarkDataKeyArr = [];
            break;
        };
        this.selectedConditionArr = [];
        for (let i = 0; i < this.trademarkDataKeyArr.length; i++) {
          this.selectedConditionArr.push(this.ncldata[this.trademarkDataKeyArr[i]].name)
        }
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      trademarkDelete(key,name) {
        if (key == 46) {
          this.trademarkPriceName = '';
          this.trademarkPriceKey = 0;
          /*this.trademarkMin = 0;
          this.trademarkMax = 0;*/
          this.min = '';
          this.max = '';
        }else if (key == 47) {
          this.trademarkStructureName = '';
          this.trademarkStructureKey = 0;
        }else if (key == 48) {
          this.trademarkNumberName = '';
          this.trademarkNumberKey = 0;
        }else {
          this.selectedConditionArr.splice(key,1);
          this.trademarkDataKeyArr.splice(key,1);
        };
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      trademarkYes () {
        if (this.trademarkMin < this.trademarkMax) {
          this.trademarkPriceKey = 0;
          /*this.trademarkPriceName = this.trademarkMin + '-' + this.trademarkMax + '万';*/
          this.trademarkPriceName = this.trademarkMin + '-' + this.trademarkMax;
          this.min = Number(this.trademarkMin);
          this.max = Number(this.trademarkMax);
          this.currentpage=1;
          this.trademarkData = [];
          this.trademarkPost();
        }else {
          this.$alert('请输入正确的价格区间', '提示', {
            confirmButtonText: '确定'
          })
        }
      },
      trademarkPrice (key,name) {
        this.trademarkPriceKey = key;
        if (name == '不限') {
          this.trademarkPriceName = '';
          this.min='';
          this.max='';
        }else if( name == '1万以下'){
          this.trademarkPriceName = name;
          this.min = 0;
          this.max = 10000;
        }else if( name == '1-2万'){
          this.trademarkPriceName = name;
          this.min = 10000;
          this.max = 20000;
        }else if( name == '2-5万'){
            this.trademarkPriceName = name;
            this.min = 20000;
            this.max = 50000;
        }else if( name == '5-8万'){
            this.trademarkPriceName = name;
            this.min = 50000;
            this.max = 80000;
        }else if( name == '8-15万'){
            this.trademarkPriceName = name;
            this.min = 80000;
            this.max = 150000;
        }else if( name == '15万以上'){
            this.trademarkPriceName = name;
            this.min = 150000;
            this.max = '';
        }
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      trademarkStructure (key,name) {
        this.trademarkStructureKey = key;
        if (name == '不限') {
          this.trademarkStructureName = '';
        }else {
          this.trademarkStructureName = name;
        } 
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      trademarkNumber (key,name) {
        if (this.trademarkStructureName != '纯图形') {
          this.trademarkNumberKey = key;
          if (name == '不限') {
            this.trademarkNumberName = '';
          }else {
            this.trademarkNumberName = name;
          }
          this.currentpage=1;
          this.trademarkData = [];
          this.trademarkPost();
        }else {
          this.$alert('纯图形条件下不可选取字数', '提示', {
            confirmButtonText: '确定'
          })
        }
      },
      trademarkTypeData (key,name,code) {
        console.log(key,name,code);
        if (key == 99) {
          this.trademarkDataKeyArr = [99];
          this.selectedConditionArr = [];
          this.currentpage=1;
          this.trademarkData = [];
          this.trademarkPost();
          return
        }
        if (this.trademarkDataKeyArr[0] == 99) {
          this.trademarkDataKeyArr.splice(0,1);
        }
        if (this.trademarkDataKeyArr.indexOf(key) == -1) {
          this.trademarkDataKeyArr.push(key);
          var a = code + '类 ' + name;
          this.selectedConditionArr.push(a);
          this.trademarkDataCoder.push(code);
        }else {
          this.trademarkDataKeyArr.splice(this.trademarkDataKeyArr.indexOf(key),1);
          this.selectedConditionArr.splice(this.selectedConditionArr.indexOf(name),1);
          this.trademarkDataCoder.splice(this.trademarkDataCoder.indexOf(code),1);
        }
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      trademarkSorting (key,name) {
        
        this.trademarkSortingName = name;
        if (this.trademarkSortingKeyArr.indexOf(key) == -1) {
          this.trademarkSortingKeyArr=[];
          this.trademarkSortingKeyArr.push(key);
          this.trademarkSort = 'DESC'; 
        }else {
          this.trademarkSortingArr[key].type = !this.trademarkSortingArr[key].type;
          if (!this.trademarkSortingArr[key].type) {
            this.trademarkSort = 'DESC';
            this.trademarkSortingKeyArr.splice(this.trademarkSortingKeyArr.indexOf(key),1);
          }else {
            this.trademarkSort = 'ASC';
          }
        }
        this.currentpage=1;
        this.trademarkData = [];
        this.trademarkPost();
      },
      ncldataShowHide () {
        this.trademarkType = !this.trademarkType;
        if (!this.trademarkType) {
          this.trademarkHeight = 'height:28px;'
        }else {
          this.trademarkHeight = ''
        }
      }

    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    vname:"gsb_tmtransactionmarket"
}
