const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("orderreceiptvoucher", {//收款单：
    uapp_id: DataTypes.INTEGER,      //  
    sourceOrderNo: DataTypes.STRING(128),   // 来源单号 
    accountType: {
      //帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.pay_account_type),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.pay_account_type[val]);
      }
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
    }, 
    payDate: DataTypes.DATE,//支付时间
    totalSum: DataTypes.DECIMAL(12, 3),//订单总额
    passTradeNo: DataTypes.STRING,//通道的统一订单号
    payOrderNo: DataTypes.STRING, //支付凭证流水单号，如：微信支付凭证单号

    wxPayOrderCode: DataTypes.STRING(64),//业务微信支付订单号
    aliPayOrderCode: DataTypes.STRING(50),//业务支付宝支付订单号
    busPayOrderCode: DataTypes.STRING(50),//业务支付订单号

    certifyFileUrl: DataTypes.STRING(500), //支付证明文件Url
    buyerOpenId: DataTypes.STRING,//用户在支付商户appid下的唯一标识或买家在支付宝的用户id    
    buyerAliLogonId: DataTypes.STRING,//买家支付宝账号
    auditStatusName: {
      type: DataTypes.STRING(50),
      defaultValue: "待审核",
    },
    auditStatus: {//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.audit_status),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.audit_status[val]);
      },
      defaultValue: "dsh",
    },  
    notes: DataTypes.STRING,//备注
    opNotes: DataTypes.STRING,//操作备注
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_order_receiptvoucher',
      validate: {
      }
    });
}
