const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class MagCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "magCache";
  }
  desc() {
    return "应用UI配置缓存";
  }
  //暂时没有用到，只是使用其帮助的方法
  prefix() {
    return settings.cacheprefix + "_uiconfig:";
  }

  async getCacheSmembersByKey(key) {
    return this.redisClient.smembers(key);
  }
  async delCacheBySrem(key, value) {
    return this.redisClient.srem(key, value)
  }
  async keys(p) {
    return this.redisClient.keys(p);
  }
  async get(k) {
    return this.redisClient.get(k);
  }
  async del(k) {
    return this.redisClient.delete(k);
  }
  async clearAll() {
    console.log("xxxxxxxxxxxxxxxxxxxclearAll............");
    return this.redisClient.flushall();
  }
}
module.exports = MagCache;
