# <a name="menu" href="">企业服务信息查询</a>


1. [获取token](#getToken)

5. [企业基本信息](#getRegisterInfo)
5. [企业股东及出资信息](#getShareHolderInfo)
5. [企业变更信息](#getRegisterChangeInfo)
5. [企业主要管理人员](#getMainManagerInfo)
5. [企业专利详情](#getPatentDetailInfo)
5. [企业专利列表](#getPatentInfo)
7. [企业商标列表](#getTrademarkInfo)
5. [企业软件著作权信息](#getSoftwareCopyrightInfo)
5. [企业作品著作权信息](#getWorksCopyrightInfo)
5. [企业LOGO](#getEntLogoInfo)
11. [企业年报社保信息](#getEntAnnReportSocialSecurityInfo)
5. [上市公司基本信息](#getListedCompanyBaseMessageInfoV2)
5. [上市公司十大股东](#getListedCompanyShareHolderInfoV2)
5. [企业实缴风险预警](#getEntPaidInRiskWarmInfo)
5. [企业数据发现](#getDataExploreInfo)
5. [企业基因标签](#getEntLable)
17. [企业联系方式汇总](#getEntContactInfo)
11. [企业/农专年报列表](#getEntSFCAnnreportList)
5. [企业年报基本信息](#getEntAnnReportInfo)
5. [企业年报网站网店信息](#getEntAnnReportWebSiteInfo)
5. [企业年报股东及出资信息](#getEntAnnReportInvInfo)
5. [企业年报资产状况](#getEntAnnReportAssetsInfo)
5. [企业年报对外担保信息](#getEntAnnReportForGuaranteeInfo)
11. [农专年报基本信息](#getSfcAnnReportInfo)
5. [农专年报网站网店信息](#getSfcAnnReportWebSiteInfo)
5. [农专年报资产状况](#getSfcAnnReportAssetsInfo)
5. [企业商标详情](#getTrademarkDetailInfo)
5. [企业年报对外投资](#getEntAnnReportToInvInfo)
5. [企业年报股权变更信息](#getEntAnnReportStockChanageInfo)



## **<a name=""> 域名</a>**
##### URL
https://oapidev.gongsibao.com/  测试
https://oapid.gongsibao.com/    线上


## **<a name="getToken"> 获取token</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/platform/getToken]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
``` javascript
    {
        "accessKey":"111",
        "accessSecret":"222"
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhcHBJZCI6MSwiZXhwIjoxNjEzNjMzMTk0LCJpYXQiOjE2MTM2MzEzOTQsImNoYW5uZWxJZCI6MX0.MQoqGHwcXVrRfbftlxgY3-o6uCi6V2jQJL5z_chLHq4",
        "msg": "success"
    }

```

## **<a name=""> 获取token2</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/platform/getTokenByApp]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
``` javascript
    {
        "channelId":1,
        "appId":1,
        "accessKey": "111"
    }
```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhcHBJZCI6MSwiZXhwIjoxNjA3OTk4MTkwLCJpYXQiOjE2MDc5OTYzOTAsImNoYW5uZWxJZCI6MX0.GtlGqOriQb6vEOkBio_8sIjvjN3W-ajQV6woG7JJ8jY",
        "msg": "success"
    }

```

## **<a name="getRegisterInfo"> 获取企业基本信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getRegisterInfo",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ENTSTATUS": "在营（开业）企业", //经营状态
                "INDUSTRY_CODE": "M", //行业领域代码
                "CANDATE": "",  //注销日期
                "REGORG": "北京市海淀区市场监督管理局", //登记机关
                "OLDNAME": "", //曾用名
                "JWD": "东经：116.171798 北纬：40.067381", //地理坐标
                "APPRDATE": "2021-01-07", //核准日期
                "OPFROM": "2014-08-07", //经营期限自
                "SHXYDM": "911101083066224948", //统一社会信用代码
                "ORGID": "306622494", //组织机构代码
                "DOM": "北京市海淀区北清路164号28-38号院1003号", //地址
                "INDUSTRY": "科学研究和技术服务业", //行业领域
                "REGCAP": 100.0, //注册资本
                "REGCAPCUR": "人民币", //注册资本币种
                "REVDATE": "", //吊销日期
                "ENTTYPE": "有限责任公司(法人独资)", //企业类型
                "FRDB": "李丽", //法定代表人
                "ENDDATE": "", //死亡日期
                "OPSCOPE": "技术开发、技术推广、技术转让、技术咨询、技术服务；计算机系统服务。。。", //经营业务范围
                "ESDATE": "2014-08-07", //成立日期
                "OPTO": "2034-08-06", //经营期限至
                "ENTNAME": "汉唐信通（北京）科技有限公司", //企业名称
                "PROVINCE": "北京市", //登记地省份
                "ENGNAME": "Hantang Xintong (Beijing) Technology Co., Ltd.", //企业英文名
                "WEBSITE": "http://www.gongsibao.com" //企业官网
            }
        ],
        "msg": "success"
    }

```

## **<a name="getShareHolderInfo"> 企业股东及出资信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getShareHolderInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100

    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "INV": "汉唐信通（北京）咨询股份有限公司", //股东名称
                "SUBCONAM": 100.0, //认缴出资额
                "CONDATE": "2014-09-07", //出资时间
                "CONCUR": "人民币", //出资币种
                "SHXYDM": "911101057889696760", //统一社会信用代码
                "CONRATIO": 1.0, //出资比例
                "INVTYPE": "法人股东" //股东类型
            }
        ],
        "msg": "success"
    }

```

## **<a name="getRegisterChangeInfo"> 企业变更信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getRegisterChangeInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ALTDATE": "2020-11-23", //变更时间
                "ALTAF": "北京市海淀区北清路164号28-38号院1003号", //变更后内容
                "ALTITEM": "住所", //变更事项
                "ALTBE": "北京市海淀区温泉镇创客小镇社区配套商业楼15#楼一层118室" //变更前内容
            }
        ],
        "msg": "success"
    }

```

## **<a name="getMainManagerInfo"> 企业主要管理人员</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getMainManagerInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ISFRDB": "是", //是否法定代表人
                "POSITION": "执行董事,经理", //职务
                "NAME": "李丽" //姓名
            }
        ],
        "msg": "success"
    }

```

## **<a name="getPatentDetailInfo"> 企业专利详情</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/postApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
``` javascript
    {
        "path":"getPatentDetailInfo",
        "rowKey":"a8a5d4f45975af887565e5ef209bfc73|9b75ce7f30c1d9024bfb0a2e6d802593" //专利列表接口返回的rowKey
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "FZL_MC": "一种基于知识图谱的企业商机挖掘方法和装置", //专利名称
                "FZL_SQH": "CN202011090162.0", //申请号
                "FZL_SQR": "2020-10-13", //申请日期
                "FZL_ZLLX": "发明专利", //专利类型
                "FZL_ZFLH": "G06F16/2458(2019.01)I", //主分类号
                "FZL_FLH": "G06F16/2458(2019.01)I;G06F16/36(2019.01)I;G06Q30/02(2012.01)I", //分类号
                "FZL_GKGGH": "CN112231350A", //公开（公告）号
                "FZL_GKGGR": "2021-01-15", //公开（公告）日
                "FZL_ZFLH_3CN": "计算；推算；计数", //专利技术领域
                "FZL_SQZLQR": "汉唐信通(北京)科技有限公司", //申请（专利权）人
                "FZL_FMSJR": "任智军;李丽;樊辉;高宇强;黄静;胥辛雨", //发明（设计）人
                "FZL_FLZT": "实质审查的生效", //法律状态
                "FZL_VALIDITY": "公开", //专利有效性
                "FZL_ZLDLJG": "北京易知宝知识产权代理事务所(普通合伙) 11875", //专利代理机构
                "FZL_DLR": "史琳琳", //代理人
                "FZL_ZY": "本公开提供一种基于知识图谱的企业商机挖掘方法及装置、计算设备及存储介。。。" //摘要
            }
        ],
        "msg": "success"
    }

```

## **<a name="getPatentInfo"> 企业专利列表</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getPatentInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
        
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ROWKEY": "a8a5d4f45975af887565e5ef209bfc73|9b75ce7f30c1d9024bfb0a2e6d802593", //rowkey，查询专利详情使用
                "FZL_MC": "一种基于知识图谱的企业商机挖掘方法和装置", //专利名称
                "FZL_SQH": "CN202011090162.0", //申请号
                "FZL_SQR": "2020-10-13", //申请日期
                "FZL_ZLLX": "发明专利", //专利类型
                "FZL_ZFLH": "G06F16/2458(2019.01)I", //主分类号
                "FZL_FLH": "G06F16/2458(2019.01)I;G06F16/36(2019.01)I;G06Q30/02(2012.01)I", //分类号
                "FZL_GKGGH": "CN112231350A", //公开（公告）号
                "FZL_GKGGR": "2021-01-15", //公开（公告）日
                "FZL_ZFLH_3CN": "计算；推算；计数", //专利技术领域
                "FZL_SQZLQR": "汉唐信通(北京)科技有限公司", //申请（专利权）人
                "FZL_FMSJR": "任智军;李丽;樊辉;高宇强;黄静;胥辛雨", //发明（设计）人
                "FZL_FLZT": "实质审查的生效", //法律状态
                "FZL_VALIDITY": "公开", //专利有效性
                "FZL_ZLDLJG": "北京易知宝知识产权代理事务所(普通合伙) 11875", //专利代理机构
                "FZL_DLR": "史琳琳", //代理人
                "FZL_DZ": "100089 北京市海淀区温泉镇创客小镇社区配套商业楼15#楼一层118室", //详细地址
                "FZL_YXQ": "", //优先权
                "FFL_SQGGH": "" //授权号
            }
        ],
        "msg": "success"
    }

```

## **<a name="getTrademarkInfo"> 企业商标列表</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getTrademarkInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ROWKEY": "a8a5d4f45975af887565e5ef209bfc73|f91096e4db8cc9d1a130064ca7537ee8", //Rowkey，查询商标详情使用
                "MARKNAME": "公司宝", //商标名称
                "APPDATE": "2019-11-27", //申请日期
                "UNIONTYPE": "45", //国际分类
                "UNIONTYPENAME": "社会服务", //国际分类名称
                "TYPEDETAILDES": "计算机软件许可（法律服务）；域名注册（法律服务）；知识产权代理。。。法律研究；诉讼服务", //商品服务列表
                "BEGINDATE": "", //专用期起
                "ENDDATE": "", //专用期止
                "CHECKDATE": "", //初审公告日期
                "REGDATE": "", //注册公告日期
                "MARKTYPE": "一般", //商标类型
                "MARKIMAGE": "/9j/4QCpRXhpZgAASUkqAAgAAAAFABIBAwABAAAAA", //商标图片
                "NOTE": "否", //是否共有商标
                "TYPEDETAIL": "4506；4505", //类似群
                "MARKCODE_KEY": "42645186", //注册号
                "ISINVALID": "有效", //状态
                "ISCOLOR": "", //指定颜色
                "AGENTNAME": "汉唐信通（北京）咨询股份有限公司", //代理机构
                "REGVOLUMN": "", //注册公告期
                "CHECKVOLUMN": "", //初审公告期
                "LIUCHENG": "商标注册申请", //商标流程
                "LIUCHENGDATE": "2020-06-13", //流程日期
                "ADDR": "北京市海淀区北清路164号17-27号院813号", //申请人中文地址
                "FSTAPPDATE": "" //优先权时间
            }
        ],
        "msg": "success"
    }

```

## **<a name="getSoftwareCopyrightInfo"> 企业软件著作权信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getSoftwareCopyrightInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "FRJ_HYFLH": "其他行业", //行业领域
                "FRJ_DJH": "2019SR1110958", //登记号
                "FRJ_RJQC": "蜂擎云服CRM系统", //软件全称
                "FRJ_DJDATE": "2019-11-01", //登记日期
                "FRJ_SCFBDATE": "2019-01-28", //首次发表日期
                "FRJ_BBH": "V1.0", //版本号
                "FRJ_ZZQR_GJ": "汉唐信通（北京）科技有限公司:中国", //著作权人
                "FRJ_RJJC": "蜂擎云服CRM", //软件简称
                "FRJ_RJFLH": "行业应用软件" //软件分类
            }
        ],
        "msg": "success"
    }

```

## **<a name="getWorksCopyrightInfo"> 企业作品著作权信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getWorksCopyrightInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "FZD_SCFBDATE": "2015-08-20", //首次发表日期
                "FZD_DJH": "国作登字-2016-F-00297528", //登记号
                "FZD_DJDATE": "2016-08-19", //登记日期
                "FZD_CZWCDATE": "2015-08-20", //创作完成日期
                "FZD_ZPMC": "表情小蜜蜂", //作品名称
                "FZD_ZPLB": "美术", //作品类别
                "FZD_ZZNAME": "" //著作权人
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntLogoInfo"> 企业LOGO</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntLogoInfo",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "LOGO": "iVBORw0KGgoAAAANSUhEUgAAASwAAAEsCAYAAAA/wD/qDQzy5/" //企业LOGO，Base64编码格式
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportSocialSecurityInfo"> 企业年报社保信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportSocialSecurityInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "D1": "", //单位参加城镇职工基本养老保险累计欠缴金额
                "C1": "", //参加城镇职工基本养老保险本期实际缴费基数
                "D2": "", //单位参加失业保险累计欠缴金额
                "B1": "", //单位参加城镇职工基本养老保险缴费基数
                "C2": "", //参加失业保险本期实际缴费基数
                "D3": "", //单位参加职工基本医疗保险累计欠缴金额
                "A1": "279", //城镇职工基本养老保险
                "B2": "", //单位参加失业保险缴费基数
                "C3": "", //参加职工基本医疗保险本期实际缴费基数
                "D4": "", //单位参加工伤保险累计欠缴金额
                "A2": "279", //失业保险
                "B3": "", //单位参加职工基本医疗保险缴费基数
                "C4": "", //参加工伤保险本期实际缴费基数
                "D5": "", //单位参加生育保险累计欠缴金额
                "A3": "279", //职工基本医疗保险
                "C5": "", //参加生育保险本期实际缴费基数
                "A4": "279", //工伤保险
                "B5": "", //单位参加生育保险缴费基数
                "A5": "279" //生育保险
            }
        ],
        "msg": "success"
    }

```

## **<a name="getListedCompanyBaseMessageInfoV2"> 上市公司基本信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getListedCompanyBaseMessageInfoV2",
        "entName":"汉唐信通（北京）科技有限公司"
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ENAME": "Fengqing Network Technology Co.,Ltd.", //英文全称
                "BUILD_DATE": "1995-01-18", //成立日期
                "DECLAREDATE": "2021-01-14", //信息发布日期
                "LIST_ENDDATE": "", //退市日期
                "STAFF_NUM": "1780", //员工人数
                "WEB_SITE": "www.Fengqing.com", //公司网址
                "PRI_BIZ": "以蜂擎企业云服务为核心为客户提供企业云服务与解决方案。", //主营业务
                "CURNCY": "人民币", //币种
                "ESNAME": "Fengqing", //英文简称
                "ISIN": "CNE0001017Y6", //ISIN代码
                "TRADE_MKT_REF": "上海证券交易所", //市场代码
                "REGI_CAP": "328082.98", //注册资本
                "CSNAME": "蜂擎网络", //中文简称
                "LIST_DATE": "2001-05-18", //上市日期
                "STK_TYPE_REF": "国内A股", //证券类别
                "COM_BRIEF": "公司是根据《中华人民共和国公司法》于1983年12月6日注册成立的股份有限公司。本公司根据2004年4月29日股东大会决议,公司名称。。。", //公司简介
                "STOCKCODE": "600588", //证券代码
                "REGI_ADDR": "北京市朝阳区", //注册地址
                "OFFICE_ADDR": "北京市朝阳区", //办公地址
                "CNAME": "蜂擎网络科技股份有限公司", //中文全称
                "STOCKSNAME": "蜂擎网络", //股票简称
                "STATUS_TYPE_REF": "上市" //上市状态
            }
        ],
        "msg": "success"
    }

```

## **<a name="getListedCompanyShareHolderInfoV2"> 上市公司十大股东</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getListedCompanyShareHolderInfoV2",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ORGCODE": "73209192", //股东代码
                "ADD_NUM": "-1,964,765", //本期变动数量
                "DECLAREDATE": "2020-10-31", //信息发布日期
                "FROZEN_PLEDGE_NUM": "0", //质押或冻结的股份数量
                "RANK": "10", //股东排名
                "HOLD_PCT": "1.693", //持股数量占总股本比例
                "SHR_HLD_TYPE": "境内法人股", //股东股权性质
                "HOLD_NUM": "55000000", //持股数量
                "ENDDATE": "2020-09-30", //截止日期
                "NAME": "上海合道资产管理有限公司－合道科创1期私募证券投资基金" //股东名称
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntPaidInRiskWarmInfo"> 企业实缴风险预警</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntPaidInRiskWarmInfo",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ACCONAM": 100.0, //实缴出资额
                "RATE": 1.0, //实缴比例
                "ENTNAME": "汉唐信通（北京）科技有限公司" //企业名称
            }
        ],
        "msg": "success"
    }

```

## **<a name="getDataExploreInfo"> 企业数据发现</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getDataExploreInfo",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
    "status": 1,
    "data": [
        {
            "DESCRIPTION": "企业2009年07月19日在上海证券交易所主板上市。", //认定依据
            "SOURCE": "中国证券监督管理委员会", //信息来源
            "LEVEL": "2", //影响程度，1=提示，2=中性
            "EVENT": "A股 | 蜂擎云服 710577.SH", //发现内容
            "MONITORTIME": "2007-04-20" //发现时间
        }
    ],
    "msg": "success"
}

```

## **<a name="getEntLable"> 企业基因标签</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntLable",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "pageNo": 1, //页码
        "pageSize": 10 //每页显示最大数量，最大100
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "TAG": "域名备案企业" //标签名称
            },
            {
                "TAG": "高新企业" //标签名称
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntContactInfo"> 企业联系方式汇总</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntContactInfo",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "CONTACT": "010-84927588", //联系方式
                "CONTACT_TYPE": "固话", //联系方式类型
                "UPDATE": "2019-03-29" //更新时间
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntSFCAnnreportList"> 企业/农专年报列表</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntSFCAnnreportList",
        "entName":"汉唐信通（北京）科技有限公司" //企业名称
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "NBYEAR": "2018", //年报年份
                "NBDATE": "2019-03-29", //年报时间
                "ENTTYPE": "企业" //企业类型
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportInfo"> 企业年报基本信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate": 2019 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ISWEB": "是", //是否有网站或网店
                "ENTSTATUS": "开业", //企业经营状态
                "POSTCODE": "100000", //邮政编码
                "ISGQZR": "否", //有限责任公司本年度是否发生股东股权转让
                "ENTNAME": "汉唐信通（北京）科技有限公司", //企业名称
                "TEL": "010-8492788", //企业联系电话
                "EMAIL": "lisa@gongsibao.com", //电子邮箱
                "SHXYDM": "911101083066224948", //统一社会信用代码
                "ISGMGQ": "是", //企业是否有投资信息或购买其他公司股权
                "ADDR": "北京市海淀区北清路164号17-27号院813号", //企业通信地址
                "EMPNUM": "10000" //从业人数
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportWebSiteInfo"> 企业年报网站网店信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportWebSiteInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate": 2019 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "WEBTYPE": "网站", //网站网店类型
                "WEBURL": "www.callcentermkt.com", //网站（网店）网址
                "WEBNAME": "汉唐信通（北京）科技有限公司" //网站（网店）名称
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportInvInfo"> 企业年报股东及出资信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportInvInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate": 2019 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ACCONAM": 100.0, //实缴出资额
                "ACCCUR": "人民币", //实缴币种
                "ACCDATE": "2015-05-23", //实缴出资时间
                "CONFORM": "货币", //认缴出资方式
                "CONAM": 100.0, //认缴出资额
                "CONDATE": "2015-05-23", //认缴出资时间
                "CONCUR": "人民币", //认缴出资币种
                "SHANAME": "汉唐信通（北京）咨询股份有限公司", //股东名称
                "ACCFORM": "货币" //实缴出资方式
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportAssetsInfo"> 企业年报资产状况</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportAssetsInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate": 2019 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ASSGRO": "10", //资产总额
                "LIAGRO": "0", //负债总额
                "RATGRO": "0", //纳税总额
                "TOTEQU": "10", //所有者权益合计
                "VENDINC": "0", //营业总收入
                "PROGRO": "0", //利润总额
                "NETINC": "0", //净利润
                "MAIBUSINC": "0" //其中主营业务收入
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportForGuaranteeInfo"> 企业年报对外担保信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportForGuaranteeInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate": 2019 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "ZQZL": "合同", //主债权种类
                "ZQSE": 400.0, //主债权数额
                "ZWR": "沂南县佳乐食品有限公司", //债务人
                "ZQQXTO": "2016-08-19", //履行债务的期限至
                "ZQR": "沂南县城区信用社", //债权人
                "BZFS": "一般保证", //保证的方式
                "ZQQXFROM": "2016-08-28", //履行债务的期限自
                "BZQJ": "期限" //保证的期间
            },
        ],
        "msg": "success"
    }

```

## **<a name="getSfcAnnReportInfo"> 农专年报基本信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getSfcAnnReportInfo",
        "entName":"榆中丰瑞祥养殖专业合作社", //企业名称
        "reportDate": 2014 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "MEMNUM_XZ": 0.0, //本年度新增成员人数
                "MEMNUM": 5.0, //成员人数
                "REGNO": "620123NA000885X", //注册号
                "FARSPEARTNAME": "榆中丰瑞祥养殖专业合作社", //合作社名称
                "TEL": "13919486253", //联系电话
                "EMAIL": "941743007@qq.com", //电子邮箱
                "MEMNUM_NM": 5.0, //成员人数中农民人数
                "MEMNUM_TC": 0.0 //本年度退出成员人数
            }
        ],
        "msg": "success"
    }

```

## **<a name="getSfcAnnReportWebSiteInfo"> 农专年报网站网店信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getSfcAnnReportWebSiteInfo",
        "entName":"阿克苏天山雪润果业农民专业合作社", //企业名称
        "reportDate": 2014 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "WEBTYPE": "网店", //网站网店类型
                "WEBURL": "http://tsaksgnlm.taobao.com", //网站（网店）网址
                "WEBNAME": "天山阿克苏果农联盟" //网站（网店）名称
            },
        ],
        "msg": "success"
    }

```

## **<a name="getSfcAnnReportAssetsInfo"> 农专年报资产状况</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getSfcAnnReportAssetsInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate": 2014 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "PRIYEAPROFIT": "5", //盈余总额
                "PRIYEASUB": "0", //获得政府扶持资金、补助
                "RATGRO": "0", //纳税金额
                "PRIYEALOAN": "0", //金融贷款
                "PRIYEASALES": "50" //销售额或营业收入
            }
        ],
        "msg": "success"
    }

```

## **<a name="getTrademarkDetailInfo"> 企业商标详情</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/postApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
``` javascript
    {
        "path":"getTrademarkDetailInfo",
        "rowKey": "a8a5d4f45975af887565e5ef209bfc73|f91096e4db8cc9d1a130064ca7537ee8" //商标列表接口返回的rowKey
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "MARKTYPE": "一般", //商标类型
                "REGVOLUMN": "", //注册公告期
                "TYPEDETAILDES": "计算机软件许可（法律服务）；域名注册（法律服务）。。。法律研究；诉讼服务", //商品服务列表
                "REGDATE": "", //注册公告日期
                "TYPEDETAIL": "4506；4505", //类似群
                "ISCOLOR": "", //指定颜色
                "MARKIMAGE": "/9j/4QCpRXhpZgAASUkqAAgAAAAFABIAAADIBAgAUAA", //商标图片
                "MARKCODE_KEY": "42645186", //注册号
                "UNIONTYPENAME": "社会服务", //国际分类名称
                "LIUCHENGDATE": "2020-06-13", //流程日期
                "ISINVALID": "有效", //状态
                "ENDDATE": "", //专用期止
                "AGENTNAME": "汉唐信通（北京）咨询股份有限公司", //代理机构
                "FSTAPPDATE": "", //优先权时间
                "ADDR": "北京市海淀区北清路164号17-27号院813号", //申请人中文地址
                "APPDATE": "2019-11-27", //申请日期
                "UNIONTYPE": "45", //国际分类
                "NOTE": "否", //是否共有商标
                "CHECKDATE": "", //初审公告日期
                "MARKNAME": "公司宝", //商标名称
                "BEGINDATE": "", //专用期起
                "LIUCHENG": "商标注册申请", //商标流程
                "CHECKVOLUMN": "" //初审公告期
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportToInvInfo"> 企业年报对外投资</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportToInvInfo",
        "entName":"汉唐信通（北京）科技有限公司", //企业名称
        "reportDate":2014 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "REGNO": "91370102MA3QXNA", //投资设立企业或购买股权企业名称
                "ENTNAME": "汉唐信通（山东）科技有限公司" //注册号/统一社会信用代码
            },
            {
                "REGNO": "91410204MA47HAC", //投资设立企业或购买股权企业名称
                "ENTNAME": "开封市智程锦云人力资源服务有限公司" //注册号/统一社会信用代码
            }
        ],
        "msg": "success"
    }

```

## **<a name="getEntAnnReportStockChanageInfo"> 企业年报股权变更信息</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/busservices/cloudApi]
#### 参数格式  `JSON`
#### HTTP请求方式 `GET`
``` javascript
    {
        "path":"getEntAnnReportStockChanageInfo",
        "entName":"阿里巴巴（中国）网络技术有限公司", //企业名称
        "reportDate":2018 //年报年份
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": [
            {
                "INV": "淘宝（中国）软件有限公司", //股东名称
                "TRANSAMPR": 0.0, //变更前股权比例
                "ALTDATE": "2018-11-27", //股权变更日期
                "TRANSAMAFT": 78.4 //变更后股权比例
            },
            {
                "INV": "Alibaba.com China Limited", //股东名称
                "TRANSAMPR": 100.0, //变更前股权比例
                "ALTDATE": "2018-11-27", //股权变更日期
                "TRANSAMAFT": 21.6 //变更后股权比例
            }
        ],
        "msg": "success"
    }

```