const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");

class CacheService {
  constructor() {
    this.cacheManager = system.getObject("db.common.cacheManager");
  }
  async buildCacheRtn(pageValues) {
    var ps = pageValues.map(k => {
      var tmpList = k.split("|");
      if (tmpList.length == 2) {
        return { name: tmpList[0], val: tmpList[1], key: k };
      }
    });
    return ps;
  }
  async findAndCountAll(obj) {
    const pageNo = obj.pageInfo.pageNo;
    const pageSize = obj.pageInfo.pageSize;
    const limit = pageSize;
    const offset = (pageNo - 1) * pageSize;
    var search_name = obj.search && obj.search.name ? obj.search.name : "";

    var cacheCacheKeyPrefix = "sadd_children_appkeys:" + settings.appKey + "_cachekey";
    var cacheList = await this.cacheManager["MagCache"].getCacheSmembersByKey(cacheCacheKeyPrefix);
    if (search_name) {
      cacheList = cacheList.filter(f => f.indexOf(search_name) >= 0);
    }
    var pageValues = cacheList.slice(offset, offset + limit);
    var kobjs = await this.buildCacheRtn(pageValues);
    var tmpList = { results: { rows: kobjs, count: cacheList.length } };
    return system.getResultSuccess(tmpList);
  }
  //app调用次数
  async findAndCountAlldetail(obj) {
    var apicallAccu = await this.cacheManager["ApiAccuCache"].getApiCallAccu(obj);
    var result = { rows: [], count: 0 };
    var keys = await this.cacheManager["MagCache"].keys("api_call_" + appkey + "*");
    var detail = null;
    for (let j = 0; j < keys.length; j++) {
      var d = keys[j];
      var pathdetail = d.substr(d.lastIndexOf("_") + 1, d.length);
      var apicalldetailAccu = await this.cacheManager["ApiCallCountCache"].getApiCallCount(appkey, pathdetail);
      var detail = { "detailPath": d, "detailCount": apicalldetailAccu.callcount };
    }
    result.rows = detail;
  }
  async delCache(obj) {
    var keyList = obj.del_cachekey.split("|");
    if (keyList.length == 2) {
      var cacheCacheKeyPrefix = "sadd_children_appkeys:" + settings.appKey + "_cachekey";
      await this.cacheManager["MagCache"].delCacheBySrem(cacheCacheKeyPrefix, obj.del_cachekey);
      await this.cacheManager["MagCache"].del(keyList[0]);
      return { status: 0 };
    }
  }
  async clearAllCache(obj) {
    await this.cacheManager["MagCache"].clearAll();
    return { status: 0 };
  }

  //发送来源APP的访问计数到目标APP，由目标APP根据逻辑进行是否禁止来源APP的访问
  //拦截访问之前由拦截器发送给目标程序
  async recvNotificationForCacheCount(pobj){
    var isHasAuth=false;
    //var srcAPPAccessCount=pobj.count;
   // var srcAPPAccessAmount=pobj.amount;
    //按照来源访问APP，查询来源APP所有者账户余额，如果小于当前
    //0为禁止，1或null为正常
    console.log("recvNotificationForCacheCountxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    if(isHasAuth){
      await this.cacheManager["ApiAccessControlCache"].cache(pobj.srcappkey,1);
    }else{
      await this.cacheManager["ApiAccessControlCache"].cache(pobj.srcappkey,0);
    }
    return isHasAuth;
  }
}
module.exports = CacheService;
