var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OpNeed extends APIBase {
    constructor() {
        super();
        this.utilsOpNeedSve = system.getObject("service.utilsSve.utilsOpNeedSve");
        this.centerorderSve = system.getObject("service.common.centerorderSve");
    }

    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_process, action_type, action_body, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "opSubmitNeed"://提交需求 2020 0807 lin 新增 
                opResult = await this.utilsOpNeedSve.opSubmitNeed(pobj, pobj.actionBody);
                break;
            case "opNeedList"://需求列表
                opResult = await this.utilsOpNeedSve.opNeedList(pobj, pobj.actionBody);
                break;
            case "opNeedClose"://关闭需求
                opResult = await this.utilsOpNeedSve.opNeedClose(pobj, pobj.actionBody);
                break;
            case "opNeedDetailByChannelNo"://需求详情－－包含方案
                opResult = await this.utilsOpNeedSve.opNeedDetailByChannelNo(pobj, pobj.actionBody);
                break;
            case "getItemByNeedNo"://需求详情
                opResult = await this.utilsOpNeedSve.getItemByNeedNo(pobj, pobj.actionBody);
                break;
            case "test"://2020 0826 lin 测试使用
                opResult = await this.utilsOpNeedSve.test(pobj, pobj.actionBody);
                break;

            // case "getItemByChannelNeedNo"://方案反馈
            //     opResult = await this.utilsOpNeedSve.getItemByChannelNeedNo(pobj, pobj.actionBody);
            //     break;
            // case "receiveFeedback"://关闭方案
            //     opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
            //     break;           
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = OpNeed;