//百度工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class RegAPI extends APIBase {
    constructor() {
        super();
        this.regCenterOrderSve = system.getObject("service.common.regCenterOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            //-----------接入百度reg------start----laolan--2020.12.17----------------------------
            //---------2.
            case "submitRegNeed"://提交需求
                opResult = await this.regCenterOrderSve.submitRegNeed(pobj, pobj.actionBody);
                break;
            case "regFeedbackSubmit"://接收方案反馈信息
                pobj.actionType = "regFeedbackSubmit";
                opResult = await this.regCenterOrderSve.reqCenterOrderRegApi(pobj);
                break;
            case "regOrderStatus"://reg方案更新
                opResult = await this.regCenterOrderSve.regOrderStatus(pobj, pobj.actionBody);
                if (opResult.status == 0 && pobj.actionBody.status == 1) {
                    opResult = await self.centerorderSve.regPaySuccess(pobj, pobj.actionBody);
                }
                break;
            case "regOrderClose"://关闭reg订单
                opResult = await this.regCenterOrderSve.regOrderClose(pobj, pobj.actionBody);
                break;
            case "getItemByChannelSolutionNo":
                opResult = await this.regCenterOrderSve.getItemByChannelSolutionNo(pobj, pobj.actionBody);
                break;
            case "getSolutionByChannelOrderNo"://根据渠道订单获取方案信息
                opResult = await this.regCenterOrderSve.getSolutionByChannelOrderNo(pobj, pobj.actionBody);
                break;
            //------------3.        
            case "regSubmitSolution"://方案提交
                opResult = await this.regCenterOrderSve.regSubmitSolution(pobj);
                break;
            case "regWriteCommunicationLog"://新增沟通记录
                opResult = await this.regCenterOrderSve.regWriteCommunicationLog(pobj);
                break;
            case "regQueryExpertCommunicationLogs"://获取沟通记录
                opResult = await this.regCenterOrderSve.regQueryExpertCommunicationLogs(pobj);
                break;
            case "regUpdateOrderStatus"://提交交付信息/修改订单状态
                opResult = await this.regCenterOrderSve.regUpdateOrderStatus(pobj);
                break;
            case "regNeedClose"://需求关闭
                opResult = await this.regCenterOrderSve.regNeedClose(pobj);
                break;
            case "regGetInfoByChannelNeedNo"://获取需求方案列表
                opResult = await this.regCenterOrderSve.reqCenterOrderApi(pobj,"action/regapi/springBoard");
                break;
            // case "closeRegSolution"://服务商方案关闭
            //     opResult = await this.regCenterOrderSve.closeRegSolution(pobj);
            //    break;
            // case "closeOrderDelivery"://交付商关闭交付单
            //     opResult = await this.regCenterOrderSve.closeOrderDelivery(pobj);
            //     break;
            
             //-----------接入百度reg------end----------------------------
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = RegAPI;