var WEBBase = require("../../web.base");
var system = require("../../../system");
class AccessAuthAPI extends WEBBase {
    constructor() {
        super();
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
        this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
        this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    }
    /**
          * 接口跳转-POST请求
          * action_process  执行的流程
          * action_type     执行的类型
          * action_body     执行的参数
          */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = system.getResult(null, "req Failure");
        pobj.actionBody.userpin = pobj.actionBody.userpin || this.getUUID();
        switch (action_type) {
            // sy
            case "test"://测试
                // var rpcParam = {
                //     accessKeyId: "LTAI4Fgz1uoUpfHpa79iq3XV",
                //     accessKeySecret: "up8vlX0wzwCVtRAjKRXsCrFta6CHOY",
                //     endpoint: "https://trademark.aliyuncs.com",
                //     apiVersion: "2019-09-02"
                // };
                // opResult = await this.utilsTmAliyunSve.getAliOssInfo(null, "ATTORNEY", rpcParam);
                // opResult = system.getResultSuccess(null, "测试成功");
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getTokenInfo"://渠道通过账户进行登录，有则返回用户信息，没有则创建用户
                opResult = system.getResultSuccess({
                    app_code: pobj.appInfo.app_code,
                    app_hosts: pobj.appInfo.app_hosts,
                    uapp_id: pobj.appInfo.uapp_id,
                    uapp_key: pobj.appInfo.uapp_key,
                    id: pobj.appInfo.id
                })
                break;
            case "getNeedUserPinByChannelUserId"://渠道通过账户进行登录，有则返回用户信息，没有则创建用户
                opResult = await this.utilsAuthSve.getLoginByUserName(req, pobj, pobj.actionBody);
                if (opResult.status != 0) {
                    return opResult;
                }
                //获取需求信息
                pobj.actionType = "getItemByChannelNeedNo";
                var needResult = await this.utilsNeedSve.getItemByChannelNeedNo(pobj, pobj.actionBody);
                if (needResult.status != 0) {
                    return needResult;
                }
                opResult.data.channelTypeCode = needResult.data.channelTypeCode;
                opResult.data.typeCode = needResult.data.typeCode
                break;
            case "getLoginByUserName"://渠道通过账户进行登录，有则返回用户信息，没有则创建用户
                opResult = await this.utilsAuthSve.getLoginByUserName(req, pobj, pobj.actionBody);
                break;
            case "getVerifyCode"://获取默认模板的手机验证码---已优化
                opResult = await this.utilsAuthSve.getVerifyCodeByMoblie(req, pobj, pobj.actionBody);
                if (opResult.status == 0) {
                    return system.getResultSuccess()
                }
                break;
            case "userPinByLgoin"://通过账户和密码登录---已优化
                opResult = await this.utilsAuthSve.getReqUserPinByLgoin(req, pobj, pobj.actionBody);
                if (opResult.status == 0) {
                    return opResult;
                }
                break;
            case "userTestLogin": // 假登陆
                if (pobj.actionBody.userName == 'usertest' && pobj.actionBody.password == 'usertest') {
                    return system.getResultSuccess({ userpin: 'ac74c45ca8e745d9b66cd3g8a3g2172a' })
                } else {
                    return system.getResultFail(-1, '用户名或密码错误')
                }
            case "userPinByLgoinVcode"://通过短信登录信息---已优化
                pobj.actionBody.reqType = "login";
                opResult = await this.utilsAuthSve.getReqUserPinByLgoinVcode(req, pobj, pobj.actionBody);
                // if (opResult.status == 0) {
                //     return system.getResultSuccess({ userpin: pobj.actionBody.userpin })
                // }
                break;
            case "userPinByRegister"://通过短信注册信息---已优化
                pobj.actionBody.reqType = "reg";
                opResult = await this.utilsAuthSve.getReqUserPinByLgoinVcode(req, pobj, pobj.actionBody);
                // if (opResult.status == 0) {
                //     return system.getResultSuccess({ userpin: pobj.actionBody.userpin })
                // }
                break;
            case "putUserPwdByMobile"://通过手机验证码修改用户密码---已优化
                opResult = await this.utilsAuthSve.putUserPwdByMobile(pobj, pobj.actionBody);
                break;
            case "putUserMobileByVcode"://通过手机验证码修改手机号，邮箱
                opResult = await this.utilsAuthSve.putUserMobileByVcode(pobj, pobj.actionBody);
                break;
            case "getLoginInfo"://通过userpin获取用户登录信息--已经废弃，在路由中处理了
                opResult = await this.utilsAuthSve.getLoginInfo(pobj, pobj.actionBody);
                break;
            case "channelUserLogin":
                opResult = await this.utilsAuthSve.channelUserLogin(pobj, pobj.actionBody, req);
                break;
            case "logout"://用户退出--已经废弃，前端自己进行移除userpin信息
                opResult = await this.utilsAuthSve.userLogout(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }


    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      */
    async getAppTokenByHosts(pobj, qobj, req) {
        var token = this.getUUID();
        pobj.actionBody.reqType = "hosts";
        var opResult = await this.utilsAuthSve.getReqTokenByHosts(pobj.actionBody, token);
        return opResult;
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      */
    async getAppTokenByAppKey(pobj, qobj, req) {
        var token = this.getUUID();
        pobj.actionBody.reqType = "appkey";
        var opResult = await this.utilsAuthSve.getReqTokenByHosts(pobj.actionBody, token);
        return opResult;
    }
}
module.exports = AccessAuthAPI;