const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const { getResultSuccess } = require("../../../system");

//区分渠道的uappid
const uappId = {
  'ali':"18",  //(阿里)
  'baidu':"44"   //(百度)
}
//推送百度城市拼音转义 2020-11-6
const cityLetter = {
  "全国":"QUANGUO"
}

//百度拼音转义 2020-11-11 laolan
const baiduIcpStatus = {
  507: "REGISTRATION",
  508: "SUBMITTED",
  509: "ACCEPTED",
  510: "NOT_ACCEPTED",
  511: "APPROVED",
  512: "NOT_APPROVED"
};
const baiduActionType = {
  "新办" : "NEW"
}

const baiduLicenseType = {
  "动漫" : "COMIC",
  "音乐" : "MUSIC"
}
/**
 * 网文相关接口(NC)
 */
class NcService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.execClient = system.getObject("util.execClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    this.opPushQueueUrl = settings.opPushQueueUrl();
    this.baiduclient = system.getObject("util.baiduClient");
  };
  //调用center-order 
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
  


  //交付材料提交 2020-11-11 laolan
  async ncSubmitMaterial(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
     console.log("cailiao ab+++++",ab)
      if(res.data.uapp_id == uappId.baidu){
        //推送数据至百度 
        var bizId = needsolution.orderChannelNo;
        console.log('bizId++',bizId)
        var pushObj = {
          "orderNo": bizId,
          "type":res.data.productType,
            "businessLicense" : {
              "name" :ab.material.businessLicense.name || "",
              "type" : ab.material.businessLicense.type || "",
              "address" :ab.material.businessLicense.address || "",
              "createdAt" : ab.material.businessLicense.createdAt || "",
              "businessTerm" :ab.material.businessLicense.businessTerm || "",
              "scopeBusiness" :ab.material.businessLicense.scopeBusiness || "",
              "enterpriseCode" :ab.material.businessLicense.enterpriseCode || "",
              "registeredCapital" : ab.material.businessLicense.registeredCapital || "",
              "legalRepresentative" :ab.material.businessLicense.legalRepresentative || "",
            },
            "material":{
              "partnerBusinessLicense": ab.material.partnerBusinessLicense || "",
              "legalPersonIdentityCard":ab.material.legalPersonIdentityCard || "",
              "businessDevelopmentDescription":ab.material.businessDevelopmentDescription || "",
              "companyPolicy":ab.material.companyPolicy || "",
              "mainManagement":ab.material.mainManagement || "",
              "creditCertificateDocument":ab.material.creditCertificateDocument || "",
              "registeredAddressCertificateDocument":ab.material.registeredAddressCertificateDocument || "",
              "partnerOtherList":ab.material.partnerOtherList || ""
            }
        };
        //推送方案材料
        var r = await this.baiduclient.baiduReqbyget({ path: "/api/bla/provider/license/material?NC_RT=", reqbody: pushObj });
        console.log('tttttttttttt++++',pushObj)
        console.log('nc rrrr+++++',r)
      }
      return system.getResultSuccess();
    }
    return res;
  }

  //提交方案 2020-11-11 laolan
  async ncSubmitSolution(pobj) {
    console.log('nc+++pobj',pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    console.log('nc+++res',res)
    if (res && res.status == 0 && res.data) {
      console.log('nc solutionContent+++',res.data.needsolution.solutionContent);
      var needsolution = res.data.needsolution;//方案信息

        //推送交付系统
        var reqParams = {
          actionBody: {
            intentionBizId: pobj.actionBody.needNo,
            status: "createSolution"
          },
          opType: "updateChanceStatus",
          appInfo: pobj.appInfo
        }
        var self = this;
        self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
        //日志记录
        self.logCtl.info({
          appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
          appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
          requestId: pobj.requestId || "",
          op: "service/impl/common/ncSve.js/ncSubmitSolution",
          content: JSON.stringify(reqParams),
          resultInfo: "",
          optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
        });
      if(res.data.needinfo.uapp_id == uappId.baidu){
        //推送数据至baidu
        var pushObj = {
          requirementId: pobj.actionBody.needNo,
          companyName: pobj.actionBody.solutionContent.solution.CompanyName,
          subType: baiduLicenseType[pobj.actionBody.solutionContent.solution.LicenseType],
          area: cityLetter[pobj.actionBody.solutionContent.solution.Area], 
          type:pobj.actionBody.solutionContent.solution.IcpType,
          actionType:baiduActionType[pobj.actionBody.solutionContent.solution.ActionType]
        };
        console.log("nc pushObj+++",pushObj);
        var r = await this.pushBaiduNcSubmitSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
        console.log('nc rr+++',r)
        return system.getResultSuccess();
      }
    }
    return res;
  }

  //推送方案baidu 2020-11-11 laolan
  async pushBaiduNcSubmitSolution(pushObj, solutionNo, appInfo, self) {
    //推送提交方案baidu
    var pushRes = await self.baiduclient.baiduReqbyget({ path: "/api/bla/provider/plan", reqbody: pushObj });
    console.log('baidu nc++++pushRes',pushRes)
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      var reqObj2 = {
        actionType: "ncReceiveProgrammeNo",
        appInfo: appInfo,
        actionBody: {
          solutionNo: solutionNo,
          solutionBizId: resData.planId
        }
      };
      console.log('zhuangtai   reqObj2++++',reqObj2)
      var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
      console.log("zhuangtai   a++++",a)
      return a;
    }
  }


  //通知交付状态变更 2020-11-11 laolan
  async ncNotification(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    console.log("nc tongzhi++res+++",res)
    if (res && res.status == 0 && res.data) {
      if(res.data.uapp_id == uappId.baidu){
        console.log('nc res.data.channelOrderNo',res.data.channelOrderNo)
        //推送数据至百度
        var pushObj = {
          orderNo: res.data.channelOrderNo,
          status: baiduIcpStatus[res.data.deliveryContent.ApplicationStatus],
        };
        //推送状态变更
        var r = await this.baiduclient.baiduReqbyget({ path: "/api/bla/provider/license/update", reqbody: pushObj });
        console.log("nc tongzhi++pushObj+++",pushObj)
        console.log("nc tongzhi+++rrr",r)
      }
      return system.getResultSuccess();
    }
    return res;
  }


  //关闭需求 2020-11-11 laolan
  async ncCloseNeed(pobj) {
    console.log("关闭需求+++",pobj)
    pobj.actionType = "ncClosePlan"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('nc 关闭需求result-----',result)
    if (result.status == 0) {
      if (result.data && result.data.orderNo) {
          pobj.actionBody.orderNo = result.data.orderNo;
          var orderrtn = await this.utilsOrderSve.delOrder(pobj, pobj.actionBody);
          console.log("orderrtn   +++   +++  ++",orderrtn)
          if (orderrtn.status < 0) {
            return system.getResultFail(-5022, "订单关闭失败");
          }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.needNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      this.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/ncSve.js/ncCloseNeed",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      if(result.data.uapp_id == uappId.baidu){
        // 推送baidu
        var pushObj  =  { 
          requirementId: pobj.actionBody.needNo, 
          status: "CLOSED",
          note : pobj.actionBody.note
        }
        var a = await this.baiduclient.baiduReqbyget({ path: "/api/bla/provider/requirement/update", reqbody:  pushObj});
        console.log('nc closeNeed+++',a)
      }
      this.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseICPNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "close fail　100389  ");
    }
  }

}
module.exports = NcService;