const system = require("../../../system");
const crypto = require('crypto');
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
//(文网文状态2020-9-26)
const wangwenStatusDisct = {
  601: "PARTNER_SUBMIT_MATERIAL",
  602: "CERT_ACCOUNT_REGISTERED",
  603: "CERT_MATERIAL_SUBMITTED",
  604: "CERT_GXB_ACCEPT",
  605: "CERT_GXB_REFUSE",
  606: "CERT_GXB_SUCCESS",
  607: "CERT_GXB_FAIL"
};

/**
 * 资质信息提报相关接口(ICP\EDI)
 */
class QcCenterOrderService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.execClient = system.getObject("util.execClient");
    this.aliclient = system.getObject("util.aliyunClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    this.opPushQueueUrl = settings.opPushQueueUrl();

  };
  //调用center-order 
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  //提交Icp注册方案
  async submitIcpProgramme(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data && res.data.needinfo && res.data.needsolution) {
      var needinfo = res.data.needinfo;//需求信息
      var needsolution = res.data.needsolution;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.solutionContent) == "string") {
        ab.solutionContent = JSON.parse(ab.solutionContent);
      }
      if (typeof (needsolution.solutionContent) == "string") {
        needsolution.solutionContent = JSON.parse(needsolution.solutionContent);
      }
      var solution = needsolution.solutionContent.solution;
      //推送数据至阿里
      var bizType = needinfo.channelTypeCode;//业务类型里
      var pushObj = {
        IntentionBizId: needinfo.channelNeedNo,
        CompanyName: solution.CompanyName, IcpType: solution.IcpType, CompanyAddress: solution.CompanyAddress,
        Area: solution.Area, Note: solution.Note,
        ActionType: solution.actionType,
        Source: "官网"
      };
      if (needsolution.channelSolutionNo) {
        pushObj["BizId"] = needsolution.channelSolutionNo;
      }
      var self = this;
      //推送方案
      // 2020 0916 lin 修改 增加获取返回值
      var pushIcpSolutionRes = await this.pushIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);

      // // 2020 0806 lin 新增推送
      // var reqParams = {
      //   actionType: "produceData",// Y 功能名称
      //   actionBody: {
      //     pushUrl: pushUrl,// Y 推送地址
      //     actionType: "updateChanceStatus",// Y 推送地址接收时的功能名称
      //     notifyUrl: "",// N 推送成功后通知的Url                 
      //     identifyCode: "ali.vat",// Y 操作的业务标识
      //     messageBody: pobj.actionBody, // Y 推送的业务消息，必须有一项对象属性值
      //     headData: ""//N 请求头信息，Json格式，如：{token:"XXXXXXX"}
      //   },
      //   requestId: pobj.requestId || "" // N 请求id
      // }
      // this.opQueuePushClientPost(pobj, this.opPushQueueUrl, reqParams);
      this.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/submitIcpProgramme",
        content: JSON.stringify(pobj),
        resultInfo: JSON.stringify(needinfo),
        optitle: "createSolution推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      var reqParams = {
        actionBody: {
          intentionBizId: needinfo.channelNeedNo,
          status: "createSolution"
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      // 
      return system.getResultSuccess(pushIcpSolutionRes);
    }
    return res;
  }
  //推送ICP方案
  async pushIcpSolution(pushObj, solutionNo, appInfo, self) {
    //推送方案信息
    var pushRes = await self.aliclient.reqbyget({ action: "SubmitIcpSolution", reqbody: pushObj, apiVersion: "2019-05-08" });
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      if (resData.BizId) {
        var reqObj2 = {
          actionType: "receiveProgrammeNo",
          appInfo: appInfo,
          actionBody: {
            solutionNo: solutionNo,
            solutionBizId: resData.BizId
          }
        };
        var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
        if (a && a.status == 0) {
          //推送方案确认信息
          var confirmRes = await self.aliclient.reqbyget({ action: "ConfirmIntention", reqbody: { BizId: pushObj.IntentionBizId }, apiVersion: "2019-05-08" });
          if (confirmRes && confirmRes.status == 0 && confirmRes.data) {
            var confirmResData = confirmRes.data;
            if (confirmResData.ConfirmUrl) {
              var reqObj3 = {
                actionType: "receiveIcpConfirmUrl",
                appInfo: appInfo,
                actionBody: {
                  solutionNo: solutionNo,
                  confirmUrl: confirmResData.ConfirmUrl
                }
              };
              var a = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
            }
          }
          return confirmRes;
        }
      }
    }
  }

  //服务商icp方案关闭
  async abolishIcpProgramme(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      //推送数据至阿里
      var pushObj = {
        BizId: ab.BizId, Note: ab.Note
      };
      //关闭方案
      this.aliclient.reqbyget({ action: "CloseIcpProduce", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }

  //交付材料提交
  async serviceProviderSubmitMaterial(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      if (typeof (ab.material) == "string") {
        ab.material = JSON.parse(ab.material);
      }
      var material = ab.material;
      //推送数据至阿里 
      var BizId = needsolution.channelSolutionNo;//⽅案业务ID
      var pushObj = {
        "BizId": BizId,
        "Domain": material.Domain,
        "CorporateName": material.CorporateName,
        "IncludeForeignInvestment": material.IncludeForeignInvestment,
        "PartnerBusinessLicense": material.PartnerBusinessLicense,
        "PartnerIdCardList": material.PartnerIdCardList,
        "PartnerDomainCertificate": material.PartnerDomainCertificate,
        "PartnerPreviewOtherList": material.PartnerPreviewOtherList || [],
        "PartnerPlan": material.PartnerPlan || "",
        "PartnerForeignInvestment": material.PartnerForeignInvestment || "",
        "PartnerLaw": material.PartnerLaw || "",
        "PartnerStampOtherList": material.PartnerStampOtherList || [],
        "PartnerSignOtherList": material.PartnerSignOtherList || [],
        "PartnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
      };
      var self = this;
      //推送方案材料
      if (pobj.appInfo.uapp_id == 18) {
        self.aliclient.reqbyget({ action: "SavePartnerSubmitMaterial", reqbody: pushObj, apiVersion: "2019-05-08" });
      }
      return system.getResultSuccess();
    }
    return res;
  }
  //通知交付状态变更
  async serviceProviderNotification(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      pobj.actionType = "getOrderByOrderNo";
      let orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
      let orderResult = await this.restPostUrl(pobj, orderUrl);
      if (orderResult.status != 0) {
        return system.getResultFail(-1, '查询订单失败')
      }
      let uapp_id = orderResult.data.uapp_id;
      pobj.appInfo = { uapp_id: uapp_id };
      pobj.actionType = "getAppInterface";
      var reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
      var productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
      if (productItemInterfaceResult.status != 0) {
        system.getResultFail(-1, '获取接口参数失败')
      }
      pobj.interface_info = productItemInterfaceResult.data;
      pobj.pushObj = res.data;
      this.utilsPushSve.pushBusInfo(pobj, 'pushStatus', 1);
      //推送数据至阿里
      // var pushObj = {
      //   BizId: res.data.BizId,
      //   OfficialFileURL: res.data.OfficialFileURL,
      //   ApplicationStatus: res.data.ApplicationStatus
      // };
      // //推送状态变更
      // this.aliclient.reqbyget({ action: "AcceptPartnerNotification", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }
  //交付单关闭
  async closeOrderDelivery(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      var needsolution = res.data;//方案信息
      var ab = pobj.actionBody;
      //推送数据至阿里
      var pushObj = {
        BizId: needsolution.channelSolutionNo, Note: ab.note
      };
      //关闭方案
      this.aliclient.reqbyget({ action: "CloseIcpProduce", reqbody: pushObj, apiVersion: "2019-05-08" });
      return system.getResultSuccess();
    }
    return res;
  }

  // ----------- 文网文 ----------- 

  //服务商提交服务操作(文网文)2020-9-26
  async serviceSubmitOption(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      //推送数据至阿里
      var resStatus = res.data.ApplicationStatus;
      var pushObj = {
        BizId: pobj.actionBody.orderNo,
        BizType: pobj.actionBody.channelType,
        OperateType: wangwenStatusDisct[resStatus],
        ExtInfo: pobj.actionBody.extInfo
      };
      console.log("fuwu++++pushObj", pushObj);
      //推送状态变更
      var r = await this.aliclient.reqbyget({ action: "OperateProduceForPartner", reqbody: pushObj, apiVersion: "2020-03-06" });
      console.log('ttttssss', r)
      return system.getResultSuccess();
    }
    return res;
  }

  //提交方案(文网文)2020-9-27
  async submitWangwenSolution(pobj) {
    console.log('文网文提交方案', pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      console.log('www', res.data.needsolution.solutionContent);
      var solution = res.data.needsolution.solutionContent;
      var needsolution = res.data.needsolution;//方案信息
      solution = JSON.parse(solution);
      solution = solution.solution
      solution = JSON.stringify(solution)

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: res.data.needinfo.channelNeedNo,
          status: "createSolution"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      var self = this;
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/submitWangwenSolution",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      //推送数据至阿里
      var pushObj = {
        intentionBizId: res.data.needinfo.channelNeedNo,
        bizType: res.data.needinfo.channelTypeCode,
        // solution: res.data.needsolution.solutionContent
        solution: solution
      };
      console.log("wangwen", pushObj);

      this.pushSubmitSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
      return system.getResultSuccess();
    }
    return res;
  }


  //推送方案
  async pushSubmitSolution(pushObj, solutionNo, appInfo, self) {
    //推送状态变更
    var pushRes = await this.aliclient.reqbyget({ action: "SubmitSolution", reqbody: pushObj, apiVersion: "2020-03-06" });
    console.log('wangwen++++pushRespushRes', pushRes)
    if (pushRes && pushRes.status == 0 && pushRes.data) {
      var resData = pushRes.data;
      var reqObj2 = {
        actionType: "receiveProgrammeNo",
        appInfo: appInfo,
        actionBody: {
          solutionNo: solutionNo,
          solutionBizId: resData.SolutionBizId
        }
      };
      var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
      return a;
    }
  }

  //关闭需求
  async closeNeed(pobj) {

    if (!pobj.actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100395");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100395");
    }
    var self = this;
    pobj.actionBody.intentionBizId = pobj.actionBody.needNo;
    pobj.actionType = "abolishIcpProgrammeByNeed"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('www+++result', result)
    if (result.status == 0) {
      if (result.data && result.data.orderNo) {
        pobj.actionBody.orderNo = result.data.orderNo;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.needNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/closeNeed",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      // 推送ali
      var a = await self.aliclient.reqbyget({ action: "CloseIntentionForPartner", reqbody: { IntentionBizId: pobj.actionBody.needNo, BizType: "esp.wangwen", Note: pobj.actionBody.note }, apiVersion: "2020-03-06" });
      console.log('alalallala', a)
      // 2020 1021 lin 新增查看日志
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/closeNeed",
        content: JSON.stringify(a),
        resultInfo: "",
        optitle: "推送ali关闭需求->closeNeed",
      });
      self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseWangWenNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "close fail　100389  ");
    }
  }

  //提交沟通记录
  async recordLog(pobj) {
    console.log('提交沟通记录pobj', pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (!pobj.actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100491");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100492");
    }
    var self = this;
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('www+提交沟通记录result', result)
    //推送交付系统
    var reqParams = {
      actionBody: {
        intentionBizId: pobj.actionBody.needNo,
        status: "followingUp"
      },
      opType: "updateChanceStatus",
      appInfo: pobj.appInfo
    }
    self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
    //推送数据至阿里
    var pushObj = {
      IntentionBizId: pobj.actionBody.needNo,
      note: pobj.actionBody.note
    };
    //提交沟通记录
    var r = await this.aliclient.reqbyget({ action: "SubmitIntentionNote", reqbody: pushObj, apiVersion: "2020-03-06" });

    console.log('www+提交沟通记录r', r)
    return system.getResultSuccess();
  }

  //查看沟通记录
  async recordLogList(pobj) {
    if (!pobj.actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100493");
    }
    let res = await this.aliclient.reqbyget({
      action: "ListIntentionNote", reqbody: {
        BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
        EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
        IntentionBizId: pobj.actionBody.needNo,
        PageNum: pobj.actionBody.pageNum || 1,
        PageSize: pobj.actionBody.pageSize || 10,
      }, apiVersion: "2020-03-06"
    });
    console.log('loglist-----', res)
    if (res && res.data && res.data.Data) {
      var len = res.data.Data.length;
      for (var i = 0; i < len; i++) {
        res.data.Data[i].CreateTime = res.data.Data[i].CreateTime / 1000
      }
    }
    return system.getResultSuccess(res);
  }


  // ----------- 食品 ----------- 

  //服务商提交服务操作
  async foodServiceSubmitOption(pobj) {
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (res && res.status == 0 && res.data) {
      //推送数据至阿里
      var resStatus = res.data.ApplicationStatus;
      var pushObj = {
        BizId: pobj.actionBody.orderNo,
        BizType: pobj.actionBody.channelTpye,
        OperateType: wangwenStatusDisct[resStatus],
        ExtInfo: pobj.actionBody.extInfo
      };
      //推送状态变更
      var r = await this.aliclient.reqbyget({ action: "OperateProduceForPartner", reqbody: pushObj, apiVersion: "2020-03-06" });
      console.log('ttttssss', r)
      return system.getResultSuccess();
    }
    return res;
  }

  //提交方案
  async submitFoodSolution(pobj) {
    console.log('food+++pobj', pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    console.log('food+++res', res)
    if (res && res.status == 0 && res.data) {
      console.log('food', res.data.needsolution.solutionContent);
      var solution = res.data.needsolution.solutionContent;
      var needsolution = res.data.needsolution;//方案信息
      solution = JSON.parse(solution);
      solution = solution.solution
      solution = JSON.stringify(solution)

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.needNo,
          status: "createSolution"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      var self = this;
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/submitFoodSolution",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      //推送数据至阿里
      var pushObj = {
        intentionBizId: res.data.needinfo.channelNeedNo,
        bizType: res.data.needinfo.channelTypeCode,
        // solution: res.data.needsolution.solutionContent
        solution: solution
      };
      console.log("food", pushObj);
      this.pushSubmitSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
      return system.getResultSuccess();
    }
    return res;
  }


  //关闭需求
  async foodCloseNeed(pobj) {

    if (!pobj.actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100395");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100395");
    }
    var self = this;
    pobj.actionBody.intentionBizId = pobj.actionBody.needNo;
    pobj.actionType = "abolishIcpProgrammeByNeed"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('food+++result', result)
    if (result.status == 0) {
      if (result.data) {
        pobj.actionBody.orderNo = result.data;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.needNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      var self = this;
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
      //日志记录
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/common/qcCenterOrderSve.js/foodCloseNeed",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      // 推送ali
      var a = await self.aliclient.reqbyget({ action: "CloseIntentionForPartner", reqbody: { IntentionBizId: pobj.actionBody.needNo, BizType: "esp.wangwen", Note: pobj.actionBody.note }, apiVersion: "2020-03-06" });
      self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseFoodNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "close fail　100389  ");
    }
  }

  //提交沟通记录
  async foodRecordLog(pobj) {
    console.log('提交沟通记录pobj', pobj)
    var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
    if (!pobj.actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100491");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100492");
    }
    var self = this;
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('提交沟通记录result', result)
    //推送交付系统
    var reqParams = {
      actionBody: {
        intentionBizId: pobj.actionBody.needNo,
        status: "followingUp"
      },
      opType: "updateChanceStatus",
      appInfo: pobj.appInfo
    }
    self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");
    //推送数据至阿里
    var pushObj = {
      IntentionBizId: pobj.actionBody.needNo,
      note: pobj.actionBody.note
    };
    //提交沟通记录
    var r = await this.aliclient.reqbyget({ action: "SubmitIntentionNote", reqbody: pushObj, apiVersion: "2020-03-06" });

    console.log('提交沟通记录r', r)
    return system.getResultSuccess();
  }

  //查看沟通记录
  async foodRecordLogList(pobj) {
    if (!pobj.actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100493");
    }
    let res = await this.aliclient.reqbyget({
      action: "ListIntentionNote", reqbody: {
        BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
        EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
        IntentionBizId: pobj.actionBody.needNo,
        PageNum: pobj.actionBody.pageNum || 1,
        PageSize: pobj.actionBody.pageSize || 10,
      }, apiVersion: "2020-03-06"
    });
    if (res && res.data && res.data.Data) {
      var len = res.data.Data.length;
      for (var i = 0; i < len; i++) {
        res.data.Data[i].CreateTime = res.data.Data[i].CreateTime / 1000
      }
    }
    return system.getResultSuccess(res);
  }

  //推送订单状态
  async pushOrderStatus(pobj) {
    if (!pobj.interface_params) {
      return system.getResult(null, "interface_params can not be empty，100400");
    }
    let interface_params_info = JSON.parse(pobj.interface_params);
    if (!interface_params_info || !interface_params_info.action || !interface_params_info.apiVersion) {
      return system.getResult(null, "interface_params（action、apiVersion） can not be empty，100430");
    }
    let pushObj = {
      BizId: pobj.pushObj.BizId,
      OfficialFileURL: pobj.pushObj.OfficialFileURL,
      ApplicationStatus: pobj.pushObj.ApplicationStatus
    };
    let obj = {
      action: interface_params_info.action,
      reqbody: pushObj,
      apiVersion: interface_params_info.apiVersion
    }
    let result = await this.aliclient.reqbyget(obj);
    return result;
  }

  // //推送ICP方案
  // async pushIcpSolution1(pushObj, solutionNo, appInfo, self) {
  //         //推送方案确认信息
  //         var confirmRes = await this.aliclient.reqbyget({ action: "ConfirmIntention", reqbody: { BizId: pushObj.IntentionBizId }, apiVersion: "2019-05-08" });
  //         console.log("confirmRes",confirmRes)
  //         // if (confirmRes && confirmRes.status == 0 && confirmRes.data) {
  //         //   var confirmResData = confirmRes.data;
  //         //   if (confirmResData.ConfirmUrl) {
  //         //     var reqObj3 = {
  //         //       actionType: "receiveIcpConfirmUrl",
  //         //       appInfo: appInfo,
  //         //       actionBody: {
  //         //         solutionNo: solutionNo,
  //         //         confirmUrl: confirmResData.ConfirmUrl
  //         //       }
  //         //     };
  //         //     var a = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
  //         //   }
  //         // }
  //         // return confirmRes;
  // }

}
module.exports = QcCenterOrderService;

// var a = new QcCenterOrderService();
// a.pushIcpSolution1({
//   IntentionBizId:"20201016103819000001",
// })
