var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const logCtl = system.getObject("service.common.oplogSve");
//阿里支付类
class utilsTlBankSve extends AppServiceBase {
  constructor() {
    super();
    this.centerAppUrl = settings.centerAppUrl();
  }
  //-------------------------------------------钉钉h5支付-----------------开始

  /**
   * 唤起钉钉h5支付信息---只供简单应用
   * @param {*} pobj 
   * @param {*} actionBody {total_fee:总额，单位为分，order_num:订单号，body_desc:标题描述}
   */
  async getH5AliDingPayInfo(pobj, actionBody) {
    if (!actionBody.orderNo) {
      return system.getResult(null, "actionBody.orderNo can not be empty，100110");
    }
    pobj.actionType = "getPayOrderInfo";
    var orderUrl = settings.centerOrderUrl() + "action/order/springBoard";
    var orderResult = await this.restPostUrl(pobj, orderUrl);
    if (orderResult.status != 0) {
      return orderResult;
    }
    pobj.actionBody.body_desc = orderResult.data.orderProduct.channelItemName;
    pobj.actionBody.product_id = orderResult.data.orderProduct.id;
    pobj.actionBody.total_fee = Number(orderResult.data.receiptVoucher.totalSum);
    pobj.actionBody.order_num = orderResult.data.receiptVoucher.sourceOrderNo;

    var result = await this.restPostUrl(pobj, this.centerAppUrl + "payment/aliPayment/getPayInfo");
    if (result.status != 0) {
      return result;
    }
    await this.cacheManager["TlPayLocker"].init(orderResult.data.receiptVoucher.sourceOrderNo);
    return result;
  }

  //-------------------------------------------钉钉h5支付-----------------结束

}
module.exports = utilsTlBankSve;
