const system = require("../../../system");
const AppServiceBase = require("../../app.base");
const settings = require("../../../../config/settings");
class utilsDeliverSve extends AppServiceBase{
    constructor() {
        super();
        this.centerOrderUrl = settings.centerOrderUrl();
        this.fileDealUrl = settings.fileDealUrl();
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    }

    /**
     * 交付中心推送接口
     * @param pobj
     * @returns {Promise<*>}
     */
    async pushTmReDeliver(pobj){
        try{
            var verifyResult = await this.verifyParam(pobj.actionBody);
            if(verifyResult.status !=0){
                return system.getResultFail();
            }
            pobj.actionBody = verifyResult.data;
            this.utilsPushSve.aliBusiness2Delivery(pobj, "pushTmReDeliver");
            return system.getResultSuccess();
        }catch (e) {
            return system.getResultFail();
        }
    }


    /**
     * 参数信息重组
     * @param pobj
     * @returns {Promise<{msg: *, data, status: number}>}
     */
    async verifyParam(actionBody) {
        let deliveryData ="";
        let orderNo = "";
        let tradeStatus = '';
        let applicant ={};
        if(actionBody.delivery_content){
            deliveryData = actionBody.delivery_content;
            orderNo = actionBody.order_info.orderNo;
        }
        if(actionBody.deliveryData){
            deliveryData = actionBody.deliveryData;
            orderNo = actionBody.orderNo;
        }
        if(deliveryData.deliveryStatusName){
            tradeStatus = deliveryData.deliveryStatusName;
        }
        if(Object.keys(deliveryData.applyUser).length ==0 || Object.keys(deliveryData.askForData).length == 0){
            tradeStatus = "待完善材料";
        }else{
            tradeStatus = "待审核";
        }
        applicant ={
            "askforId": deliveryData.apply.askforId,//申请号
            "applicantName": deliveryData.apply.applicantName, // 申请公司姓名
            "applicantType": deliveryData.apply.applicantType || '', // 申请人类型: 企业 个人
            "usccode": deliveryData.apply.usccode,//唯一社会信用代码
            "agentName": deliveryData.apply.agentName,//代理机构
            "tradeImg": deliveryData.apply.tradeImg,//商标图样
            "tradeType": deliveryData.apply.tradeType,
            "licenseAddr": deliveryData.applyUser.licenseAddr || '', // 营业执照地址
            "licenseDir": deliveryData.applyUser.licenseDir || '',//营业执照文件
            "duty": deliveryData.applyUser.duty || "", // 负责人职务
            "tel": deliveryData.applyUser.tel || "", // 联系人电话
            "addr": deliveryData.applyUser.addr || "", // 联系人地址
            "entrust": deliveryData.applyUser.entrust || "", // 代理委托书
            "country": deliveryData.applyUser.country || "", // 申请人国籍
            "dutyName": deliveryData.applyUser.dutyName || "", // 负责人姓名
            "contactsName": deliveryData.applyUser.contactsName || '', // 联系人姓名
            "email": deliveryData.applyUser.email || '', // 联系人邮箱
            "mailCode": deliveryData.applyUser.mailCode || '' // 邮政编码
        }
        let postData = {
            orderId:orderNo,
            askforId:deliveryData.apply.askforId,
            tradeType:deliveryData.apply.tradeType,
            tradeImg:deliveryData.apply.tradeImg,
            tradeStatus:tradeStatus,
            usccode:deliveryData.apply.usccode,
            agentName:deliveryData.apply.agentName,
            trademarkRejInfo:deliveryData.trademarkRejInfo,
            applicant:applicant,
            askForData:deliveryData.askForData,
            supData:deliveryData.supData
        }

        return system.getResultSuccess(postData);
    }

    /**
     * 提交复审申请单
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async addReviewList(pobj,actionBody){
        //参数重组
        try{
            let verifyResult = await this.verifyParam(pobj.actionBody);
            if (verifyResult.status != 0) {
                return await this.disposePushResultFail(pobj, verifyResult, "delivery->pushDelivery->verifyResult", "");
            }
            //修改交付信息
            let url = this.centerOrderUrl +"action/tmreview/springBoard";

            let result = await this.restPostUrl(pobj, url);
            if(result.status !==0){
                return system.getResult(null,result.msg)
            }
            //获取订单
            let orderUrl = this.centerOrderUrl + "action/order/springBoard";
            pobj.actionType = "getOrderDetails"
            let orderResult = await this.restPostUrl(pobj,orderUrl);
            if(orderResult.status!=0){
                return system.getResult(null,orderResult.msg);
            }
            //支付成功推送到交付中心
            if(orderResult.data && orderResult.data.orderStatus === 2){
                // 推送交付中心
                pobj.actionBody = verifyResult.data;
                this.utilsPushSve.aliBusiness2Delivery(pobj, "pushTmReDeliver");
            }
            return result;
        }catch (e) {
            return system.getResultFail(-1,e)
        }

    }

    /**
     * 商标驳回复审控制台列表+模糊查询
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async getReOrderList(pobj,actionBody){
        let url = this.centerOrderUrl + "action/tmreview/springBoard";
        let result = await this.restPostUrl(pobj, url);
        return result;
    }
    /**
     * 接收官文信息
     * @param pobj
     * @param actionBody
     * @returns {Promise<{msg: string, data, bizmsg: *|string, status: number}|any>}
     */
    async addOfficial(pobj,actionBody){
        let url = this.centerOrderUrl + 'action/tmreview/springBoard';
        let result = await this.restPostUrl(pobj, url);
        let r = {
            status: 1, //1为成功,否则为失败
            msg: "推送成功",
            data: null
        };
        if(result.status !=0){
            r.status = 0;
            r.msg = result.msg;
            return r;
        }
        return r;
    }

    /**
     * 获取官文列表
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async getOfficialList(pobj,actionBody){
        let url = this.centerOrderUrl + 'action/tmreview/springBoard';
        const result = await this.restPostUrl(pobj,url);
        return result;
    }

    /**
     * 接收交付中心信息
     * @returns {Promise<void>}
     */
    async receiveDeliveryInfo(pobj,actionBody){
        //修改交付信息
        const url = this.centerOrderUrl +"action/tmreview/springBoard";
        pobj.actionType = 'addReviewList';
        let result = await this.restPostUrl(pobj, url);
        let r = {
            status: 1, //1为成功,否则为失败
            msg: "推送成功",
            data: null
        };
        if(result.status !==0){
            r.status= 0;
            r.msg = result.msg;
            return r;
        }
        return r;
    }

    /**
     * 根据上传的驳回通知书，解析内容
     * @param pobj
     * @param actionBody
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: *, status: number}>}
     */
    async getPDFInfo(pobj,actionBody){
        if(!actionBody.url){
            return system.getResult(null,'url cant not be empty');
        }
        let url = this.fileDealUrl + "/gsb/tmreject";
        let result = await this.restPostUrl(actionBody,url);
        if(result.status !=1){
            return system.getResult(null,'解析失败，稍后重试');
        }
        // "data": {
        //     "address": "浙江省杭州市江干区太平门直街260号三新银座1521室",//通信地址
        //     "applicant": "中艺联合文化产业有限公司",//申请人
        //     "msg_number": "TMZC40902560BHTZ01"//发文号
        // }
        return system.getResult(result.data)
    }

    /**
     * 合成模板 事实与理由
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async composeDocAndDownload(pobj,actionBody){
        if(!actionBody.applicantName){
            return system.getResult(null,'申请人为空');
        }
        if(!actionBody.askforId){
            return system.getResult(null,'发文号为空');
        }
        if(!actionBody.addr){
            return system.getResult(null,'通信地址为空');
        }
        if(!actionBody.dutyName){
            return system.getResult(null,"负责人为空");
        }
        if(!actionBody.duty){
            return system.getResult(null,"职务为空");
        }
        if(!actionBody.tradeType){
            return system.getResult(null,"大类为空");
        }
        if(!actionBody.nclexist){
            return system.getResult(null,"商品类别为空");
        }
        if(!actionBody.tradeImg){
            return system.getResult(null,"商标图样为空");
        }
        if(!actionBody.isNeedSup){
            return system.getResult(null,"补充材料判断为空");
        }
        if(!actionBody.docNo){
            return system.getResult(null,"发文编号为空");
        }
        let secType='';
        actionBody.nclexist.forEach(item=>{
            secType += item.small_name +",";
        })
        secType = secType.substring(0,secType.length-1);
        let server = '';
        if(1<= +actionBody.tradeType <=34){
            server = '商品';
        }else if(35<= +actionBody.tradeType <=45){
            server = '服务';
        }
        let data ={
            applyName:actionBody.applicantName,//申请人
            addr:actionBody.addr,//通信地址
            name:actionBody.dutyName,//主要负责人
            duty:actionBody.duty,//职务
            type:actionBody.tradeType,//商标大类
            secType:secType,//商标二类
            tm_name:actionBody.tradeImg,//商标图样
            num:actionBody.askforId,//申请号
            docNo:actionBody.docNo,//发文号
            select:actionBody.isNeedSup,//是否补充材料 是 否
            server:server
        }

        let url = this.fileDealUrl + "/gsb/tmgeneratorreject";
        let result = await this.restPostUrl(data,url);
        if(result.status !=1){
            return system.getResult(null,result.msg);
        }
        return system.getResult(result.data);
    }

    /**
     * 合成模板 委托书
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async getEntrustDoc(pobj,actionBody){
        if(!actionBody.applyName){
            return system.getResult(null,'applyName can not be empty');
        }
        if(!actionBody.addr){
            return system.getResult(null,'addr can be not empty');
        }
        if(!actionBody.name){
            return system.getResult(null,'name can be not empty');
        }
        if(!actionBody.duty){
            return system.getResult(null,'duty can not be empty');
        }
        if(!actionBody.tm_name){
            return system.getResult(null,'tm_name can be not empty');
        }
        if(!actionBody.type){
            return system.getResult(null,'type can be not empty');
        }
        if(!actionBody.num){
            return system.getResult(null, 'num can be not empty');
        }
        let url = this.fileDealUrl + '/gsb/tmassessagent';
        let result =await this.restPostUrl(actionBody,url);
        if(result.status !=1){
            return system.getResultFail(-1,'合成失败！');
        }
        return system.getResult(result.data)
    }
}

module.exports = utilsDeliverSve;