var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
const { json } = require("sequelize");
// 2020 0807 lin 新增 诊断宝相关
// 接口文档地址：
class UtilsDiagnosisService extends AppServiceBase {
  constructor () {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
  }

  /**
    * 2020 0811 lin 诊断宝人工评估-开始入驻评估
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async manualEvaluation(pobj, actionBody) {
    // 诊断方式rg/只能在controller层check写zn
    actionBody.diagnosisMode = "rg"
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var manualEvaluationResult = await this.restPostUrl(pobj, reqUrl);
    return manualEvaluationResult;
  }
  /**
    * 2020 0811 lin 个人中心-诊断列表
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async diagnosisInfo (pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var diagnosisInfoResult = await this.restPostUrl(pobj, reqUrl);
    return diagnosisInfoResult;
  }
  /**
    * 2020 0811 lin 个人中心-诊断列表
    * @param {*} pobj 
    * @param {*} actionBody 
    */
   async diagnosisDetail (pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var diagnosisInfoResult = await this.restPostUrl(pobj, reqUrl);
    return diagnosisInfoResult;
  }
  /**
    * 2020 0811 lin 个人中心企业信息
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async enterpriseInfo (pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var enterpriseInfoResult = await this.restPostUrl(pobj, reqUrl);
    return enterpriseInfoResult;
  }

  /**
    * 2020 0811 lin 需求列表
    * @param {*} pobj 
    * @param {*} actionBody 
    */
   async opSubmitNeed (pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var enterpriseInfoResult = await this.restPostUrl(pobj, reqUrl);
    return enterpriseInfoResult;
  }
  /**
    * 2020 0811 lin 需求列表
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async opNeedList (pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var enterpriseInfoResult = await this.restPostUrl(pobj, reqUrl);
    return enterpriseInfoResult;
  }
  /**
    * 2020 0811 lin 需求详情
    * @param {*} pobj 
    * @param {*} actionBody 
    */
  async getItemByNeedNo (pobj, actionBody) {
    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
    var enterpriseInfoResult = await this.restPostUrl(pobj, reqUrl);
    return enterpriseInfoResult;
  }
}

module.exports = UtilsDiagnosisService;

