<a name="menu" href="/doc">返回主目录</a>

1. [政策检索](#policyQuery)
1. [政策检索(根据政策类型检索)](#policyTypeQuery)
1. [政策申请提报](#submitPolicyNeed)
1. [政策需求列表](#getPolicyNeedList)
1. [需求信息备注提交](#submitPolicyNeedNotes)
1. [获取微信签名信息](#getWxSign)
1. [提交政策订阅](#submitPolicysubscribe)
1. [取消政策订阅](#delPolicysubscribe)
1. [获取政策订阅列表](#getPolicysubscribeList)
1. [政策类型统计计数](#policyTypeCount)
1. [政策订阅检索列表(通过订阅信息查询订阅的政策信息)](#policySubscribeQuery)
1. [获取微信网页授权令牌(用于政策H5 oauth授权登录)](#getTokenAndOpenid)
1. [政策商机（蜂擎）](#getPolicyBusinessFq)
1. [政策需求信息（icompany）](#getPolicyNeedInfo)

## **<a name="policyQuery"> 政策检索(H5)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：policyQuery
``` javascript
 {
        "actionType": "policyQuery",
        "actionBody": {
           "policyName":"北京市",
           "policyProvince":"北京市",
           "policyCity":"北京市"
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "rlzy":[
            {
                "policyType":"rlzy",
                "policyTypeName":"人力资源",
                "policyDate":"2020-02-05T14:14:24.000Z",
                "policyContent":null,
                "policyCity":"北京市",
                "policyProvince":"北京市",
                "policyLinkUrl":"http://www.beijing.gov.cn/zhengce/zhengcefagui/202002/t20200206_1625493.html",
                "policySource":"京政办发〔2020〕7号",
                "policyName":"北京市人民政府办公厅关于应对新型冠状病毒感染的肺炎疫情影响促进中小微企业持续健康发展的若干措施
北京市人民政府办公厅关于应对新型冠状病毒感染的肺炎疫情影响促进中小微企业持续健康发展的若干措施",
                "policyNo":"bj001"
            }
        ],
        "fzbt":[

        ],
        "jrdk":[

        ],
        "zdfc":[

        ],
        "ssjm":[

        ]
    },
    "requestId":"2c1ebf037aed4b30aa8e497c7a151a8e"
}

```
## **<a name="policyTypeQuery"> 政策检索(根据政策类型检索)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：policyTypeQuery
``` javascript
 {
        "actionType": "policyTypeQuery",
        "actionBody": {
           "policyName":"租金",
           "policyProvince":"中央",
           "policyCity":"",
           "policyType":"rlzy" //必填
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":426,
            "policyType":"rlzy",
            "policyTypeName":"人力资源",
            "policyDate":null,
            "policyCity":"中央",
            "policyProvince":"中央",
            "policyLinkUrl":"http://www.gov.cn/zhengce/zhengceku/2020-02/08/content_5476137.htm",
            "policySource":"人社部发〔2020〕8号",
            "policyName":" 关于做好稳定劳动关系支持企业复工复产的意见",
            "policyNo":"zy041"
        },
        {
            "id":102,
            "policyType":"rlzy",
            "policyTypeName":"人力资源",
            "policyDate":null,
            "policyCity":"中央",
            "policyProvince":"中央",
            "policyLinkUrl":"http://www.mohrss.gov.cn/gkml/zcfg/gfxwj/202002/t20200205_358137.html",
            "policySource":"人社部明电〔2020〕2号",
            "policyName":"做好疫情防控期间有关就业工作的通知",
            "policyNo":"zy015"
        }
    ],
    "requestId":"a47e93c2816f464da5e822cb20ee5f8b"
}

```
## **<a name="submitPolicyNeed"> 政策申请提报(H5)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：submitPolicyNeed
``` javascript
 {
        "actionType": "submitPolicyNeed",
        "actionBody": {
          "contacts":"联系人",       
		   "company":"公司名称",    
		    "industry":"行业名称",    
		     "region":"行业名称",
		    "mobile":"13075556693",    
		    "policy_id":1,
		    "popularizeUserCode":"推广人手机号"
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestId":"6afebe73d2fa47dbb2dd451468b4e3ac"
}
```
## **<a name="getPolicyNeedList"> 政策需求列表(后台页面)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getPolicyNeedList
``` javascript
 {
        "actionType": "getPolicyNeedList",
        "actionBody": {
        	"policyName":"北京",
        	"policyProvince":"北京市",
        	"policyCity":"北京市",
        	"policyType":"rlzy",
        	"customerIntention":"dgj",
        	"pageSize":"20",
            "pageIndex":"1",
            "startDate":"2020-02-16T04:14:24.000Z",
        	"endDate":"2020-02-21T14:14:24.000Z"
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "created_at":"2020-02-16T17:52:56.000Z",
            "id":9,
            "uapp_id":26,
            "contacts":"去问问",
            "customerIntention":"wyx",
            "customerIntentionName":"无意向",
            "company":"qww",
            "industry":"err",
            "region":"where",
            "mobile":"12345578901",
            "policy_id":1,
            "applyDate":"2020-02-16T17:52:56.000Z",
            "opNotes":"{"data":[{"customerIntention":"wyx","intentionContent":"add补办了2","submitDate":"2020-02-20T06:34:19.080Z"},{"customerIntention":"wyx","intentionContent":"新增补办了","submitDate":"2020-02-20T06:33:08.132Z"}]}",
            "popularizeUserCode":"13075556693",
            "policyNo":"zy001",
            "policyName":"疫情防控重点医疗物资和生活必需品保供工作等",
            "policyType":"zdfc",
            "policyTypeName":"行政措施",
            "policySource":"国务院常务会议",
            "policyLinkUrl":"http://www.gov.cn/premier/2020-02/05/content_5474896.htm",
            "policyDate":null,
            "policyProvince":"中央",
            "policyCity":"中央"
        }
    ],
    "dataCount":1,
    "requestId":"057c0cacd9d54d0ea7356d6577d093b8"
}
```
## **<a name="submitPolicyNeedNotes"> 需求信息备注提交(后台页面)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：submitPolicyNeedNotes
``` javascript
  {
        "actionType": "submitPolicyNeedNotes",
        "actionBody": {
        	"needId":"17",
        	"customerIntention":"wyx",
        	"intentionContent":"补办了"
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestId":"0a4483b9b7ca4594b1bfc487d49746d2"
}
```
## **<a name="getWxSign"> 获取微信签名信息</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getWxSign
``` javascript
{
        "actionType": "getWxSign",
        "actionBody": {
            "url":"http://gsb.qifu.gongsibao.com/"//当前网页的URL，不包含#及其后面部分
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "jsapi_ticket":"sM4AOVdWfPE4DxkXGEs8VJK3-61YVvRLBqI-KWT682YNCdxlqHtAFxuoVHbOtb_ZoLalzqMy0jD835ajBCINAw",
        "nonceStr":"zhengcepolicy",
        "timestamp":1582012108,
        "url":"http://gsb.qifu.gongsibao.com/",
        "signature":"269a120c2e47e6b324601fb6df40f932902d0ae7",
        "appId":"wx4c91e81bbb6039cd"
    },
    "requestId":"5dc78d501b6d42c2af0f157cb1cceb28"
}
```
## **<a name="submitPolicysubscribe"> 提交政策订阅</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：submitPolicysubscribe
``` javascript
{
	"actionType":"submitPolicysubscribe",
	"actionBody":{
		"openid":"test001",
		"policyProvince":"北京市",
		"policyTypes":["jrdk","fzbt"]
	}
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestId":"6528d103010d406eaa91a2d391df4463"
}
```
## **<a name="delPolicysubscribe"> 取消政策订阅</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：delPolicysubscribe
``` javascript
{
	"actionType":"delPolicysubscribe",
	"actionBody":{
		"openid":"test001",
		"policyId":"1"
	}
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestId":"6528d103010d406eaa91a2d391df4463"
}
```
## **<a name="getPolicysubscribeList"> 获取政策订阅列表</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getPolicysubscribeList
``` javascript
{
	"actionType":"getPolicysubscribeList",
	"actionBody":{
		"openid":"test001"
	}
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":2,
            "policyProvince":"北京市",
            "policyTypes":"jrdk,fzbt",
            "created_at":"2020-02-21T07:18:54.000Z"
        }
    ],
    "requestId":"c41dd1cd791e4fe19765d8dcb8fa4b6e"
}
```
## **<a name="policyTypeCount"> 政策类型统计计数</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：policyTypeCount
``` javascript
{
        "actionType": "policyTypeCount",
        "actionBody": {
          "policyName":"租金",
          "policyProvince":"北京市"
        }
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "rlzy":144,
        "fzbt":93,
        "jrdk":124,
        "zdfc":152,
        "ssjm":91
    },
    "requestId":"bed42cc870b04a879d485a9f501df8a1"
}
```
## **<a name="policySubscribeQuery"> 政策订阅检索列表(通过订阅信息查询订阅的政策信息)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：policySubscribeQuery
``` javascript
{
        "actionType":"policySubscribeQuery",
        "actionBody":{
        	"openid":"test001",
        	"policySubscribeId":"2"
		}
 }

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":106,
            "policyType":"jrdk",
            "policyTypeName":"金融贷款",
            "policyDate":null,
            "policyCity":"北京市",
            "policyProvince":"北京市",
            "policyLinkUrl":"http://www.beijing.gov.cn/zhengce/zhengcefagui/202002/t20200206_1625493.html",
            "policySource":"京政办发〔2020〕7号",
            "policyName":"促进中小微企业持续健康发展的若干措施",
            "policyNo":"bj001"
        },
        {
            "id":107,
            "policyType":"fzbt",
            "policyTypeName":"租金减免",
            "policyDate":null,
            "policyCity":"北京市",
            "policyProvince":"北京市",
            "policyLinkUrl":"http://www.beijing.gov.cn/zhengce/zhengcefagui/202002/t20200206_1625493.html",
            "policySource":"京政办发〔2020〕7号",
            "policyName":"促进中小微企业持续健康发展的若干措施",
            "policyNo":"bj001"
        },
        {
            "id":111,
            "policyType":"jrdk",
            "policyTypeName":"金融贷款",
            "policyDate":null,
            "policyCity":"北京市",
            "policyProvince":"北京市",
            "policyLinkUrl":"http://www.beijing.gov.cn/zhengce/zhengcefagui/202002/t20200203_1622987.html",
            "policySource":"京政办发〔2020〕5号",
            "policyName":"北京市政府关于进一步支持打好肺炎疫情防控阻击战若干措施",
            "policyNo":"bj006"
        },
        ........
    ],
    "requestId":"7c7b8cea10ba4d42975bd44f1182c37c"
}
```
## **<a name="getTokenAndOpenid"> 获取微信网页授权令牌(用于政策H5 oauth授权登录)</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getTokenAndOpenid
``` javascript
{
        "actionType":"getTokenAndOpenid",
        "actionBody":{
        	"code":"CODE",
		}
 }

```
#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "access_token":"30_y2XdEQ7M8nTc20PW6iBiXqfXMnPxKJXILsYrcctt-sx_9kaEpXq0-hyhGHV1s0uIlT2BIziNVree6kR1IcQ-LMPdL9DjGUm21_hnNoweYTI",
        "expires_in":7200,
        "refresh_token":"30_1dTSPdkF7z1ezBLk1IfeHUier1BYhfmtlaWcKcvNBMggdLdgrldUPxa-oUGFAqalzqUAnYdK8xP33e7jUEimFGZOaDUHgHZsaoeKBpocnX8",
        "openid":"o7kgSs0yK_SOhRVl_LSHpL156EAE",
        "scope":"snsapi_base"
    },
    "requestId":"7c7b8cea10ba4d42975bd44f1182c37c"
}
```
## **<a name="getPolicyBusinessFq"> 政策商机（蜂擎）</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getPolicyBusinessFq
``` javascript
{
        "actionType":"getPolicyBusinessFq",
        "actionBody":{
			"policyName":"医疗物资",//政策名称
            "policyProvince":"中央",//政策省份
            "policyType":"zdfc",//政策类型编码'fzbt':'租金减免','jrdk':'金融贷款','zdfc':'行政措施','ssjm':'税收优惠','rlzy':'人力资源'
            "pageSize":"5",//分页参数 页面政策数量 默认20 不能超过200 超过200按200获取数据
            "pageIndex":"1",//分页参数 当前页码 默认1
            "startDate":"2020-02-10T04:14:24.000Z",//开始时间
            "endDate":"2020-02-21T14:14:24.000Z",//截止时间
            "salesmanMobile":"18611398533"//业务员手机号
        }
 }

```
#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "created_at":"2020-02-21T11:46:03.000Z",//申请日期
            "region":"安徽省安庆市",//申请人地区
            "mobile":"15665313398",//申请人手机号
            "industry":"生态种植、养殖、农旅",//申请人行业
            "contacts":"牛思磊",//申请人姓名
            "policyNo":"zy001",//政策编号
            "policyName":"疫情防控重点医疗物资和生活必需品保供工作等",//政策名称
            "policyType":"zdfc",//政策类型编码
            "policyTypeName":"行政措施",//政策类型
            "company":"安庆市海鸿生态农业发展有限公司",//申请企业名称
            "popularizeUserCode":"18611398533",//所属业务员手机号
            "policyLinkUrl":"http://www.gov.cn/premier/2020-02/05/content_5474896.htm",//政策链接
            "policyProvince":"中央"//政策所属省份
        },
        {
            "created_at":"2020-02-21T06:53:33.000Z",
            "region":"成都",
            "mobile":"17388438807",
            "industry":"零售",
            "contacts":"李逸雪",
            "policyNo":"zy001",
            "policyName":"疫情防控重点医疗物资和生活必需品保供工作等",
            "policyType":"zdfc",
            "policyTypeName":"行政措施",
            "company":"陕西宝胜贸易有限公司",
            "popularizeUserCode":"18611398533",
            "policyLinkUrl":"http://www.gov.cn/premier/2020-02/05/content_5474896.htm",
            "policyProvince":"中央"
        },
        {
            "created_at":"2020-02-21T09:49:38.000Z",
            "region":"北京市",
            "mobile":"15801286499",
            "industry":"医疗",
            "contacts":"陶绍芳",
            "policyNo":"zy001",
            "policyName":"疫情防控重点医疗物资和生活必需品保供工作等",
            "policyType":"zdfc",
            "policyTypeName":"行政措施",
            "company":"北京瑞轩同源医疗器械销售中心",
            "popularizeUserCode":"18611398533",
            "policyLinkUrl":"http://www.gov.cn/premier/2020-02/05/content_5474896.htm",
            "policyProvince":"中央"
        },
        {
            "created_at":"2020-02-19T15:49:21.000Z",
            "region":"安徽省安庆市",
            "mobile":"15665313398",
            "industry":"生态种植、养殖、农旅",
            "contacts":"牛思磊",
            "policyNo":"zy001",
            "policyName":"疫情防控重点医疗物资和生活必需品保供工作等",
            "policyType":"zdfc",
            "policyTypeName":"行政措施",
            "company":"安庆市海鸿生态农业发展有限公司",
            "popularizeUserCode":"18611398533",
            "policyLinkUrl":"http://www.gov.cn/premier/2020-02/05/content_5474896.htm",
            "policyProvince":"中央"
        },
        {
            "created_at":"2020-02-19T15:14:54.000Z",
            "region":"武汉市",
            "mobile":"17786045473",
            "industry":"食品",
            "contacts":"钱庆华",
            "policyNo":"zy001",
            "policyName":"疫情防控重点医疗物资和生活必需品保供工作等",
            "policyType":"zdfc",
            "policyTypeName":"行政措施",
            "company":"武汉金汉韵调味食品有限公司",
            "popularizeUserCode":"18611398533",
            "policyLinkUrl":"http://www.gov.cn/premier/2020-02/05/content_5474896.htm",
            "policyProvince":"中央"
        }
    ],
    "dataCount":15,//总条数
    "requestId":"0368996e8cec4816a92b203e692e7124"
}
```
## **<a name="getPolicyNeedInfo"> 政策需求信息（icompany）</a>**
[返回到目录](#menu)
##### URL
[/web/action/policy/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getPolicyNeedInfo
``` javascript
{
        "actionType":"getPolicyNeedInfo",
        "actionBody":{
			"contacts":"李咏梅",//申请人姓名
            "company":"苏州云逸企业管理服务有限公司",//申请企业
            "industry":"教育培训",//行业名称
            "region":"苏州",//申请人地址
            "mobile":"13862088336",//申请人电话
            "startDate":"2020-02-10T04:14:24.000Z",//开始时间
            "endDate":"2020-02-29T14:14:24.000Z"//截止时间
        }
 }

```
#### 返回结果
```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "contacts":"李咏梅",//申请人姓名
            "company":"苏州云逸企业管理服务有限公司",//申请企业
            "industry":"教育培训",//行业名称
            "region":"苏州",//申请人地址
            "mobile":"13862088336",//申请人电话
            "created_at":"2020-02-28T04:20:56.000Z"//申请时间
        }
    ],
    "dataCount":1,//总条数
    "requestId":"015ad782709d4fe3bdfdda36e4c2bca5"
}
```
