var system = require("../../../system")
const CtlBase = require("../../ctl.base");

//商户信息
class MerchantCtl extends CtlBase {
    constructor() {
        super("all", CtlBase.getServiceName(MerchantCtl));
    }

    //商户列表
    async allList(qobj) {
        var params = qobj || {};
        this.doTimeCondition(params, ["signBegin", "signEnd"]);
        try {
            var page = await this.service.signPage(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    //商户查看
    async merchantInfo(qobj) {
        var params = qobj || {};
        try {
            var page = await this.service.merchantInfo(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }


    //数据概览
    async dataSummarize(qobj) {
        var params = qobj || {};
        if (params.month) {
            let date = this.getMonthDays(params.month);
            params.signBegin = date[0];
            params.signEnd = date[date.length - 1];
        }
        this.doTimeCondition(params, ["signBegin", "signEnd"]);
        try {
            var page = await this.service.dataSummarize(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    //首页图表
    async dataChart(qobj) {
        var params = qobj || {};
        if (params.month) {
            let date = this.getMonthDays(params.month);
            params.signBegin = date[0];
            params.signEnd = date[date.length - 1];
        }
        this.doTimeCondition(params, ["signBegin", "signEnd"]);

        try {
            var page = await this.service.dataChart(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    //统计商户报表
    async commercialCount(qobj) {
        var params = qobj || {};
        try {
            var page = await this.service.commercialCount(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    //统计商户报表 详情
    async commercialList(qobj) {
        var params = qobj || {};
        if (params.month) {
            let date = this.getMonthDays(params.month);
            params.signBegin = date[0];
            params.signEnd = date[date.length - 1];
        }
        this.doTimeCondition(params, ["signBegin", "signEnd"]);
        try {
            var page = await this.service.commercialList(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }

    }


    //统计报表 个人
    async commercialCountToList(qobj) {
        var params = qobj || {};
        try {
            var page = await this.service.commercialCountTo(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    //统计报表 个人 图表
    async commercialCountToChares(qobj) {
        var params = qobj || {};
        if (params.month) {
            let date = this.getMonthDays(params.month);
            params.signBegin = date[0];
            params.signEnd = date[date.length - 1];
        }
        try {
            var page = await this.service.commercialCountToChares(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    async tenantSel(qobj) {
        var params = qobj || {};
        try {
            var page = await this.service.tenantSel(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    // async merchantInfo(qobj) {
    //     var obj = [
    //         {
    //             label: '服务商名称：',
    //             value: '舟山兰和科技有限公司'
    //         }, {
    //             label: '联系人姓名：',
    //             value: '钟韬晨'
    //         }, {
    //             label: '联系人手机：',
    //             value: '17780611107'
    //         }, {
    //             label: '联系地址：',
    //             value: '浙江省舟山市定海区舟山港总和保税区企业服务中心01-3045室'
    //         }, {
    //             label: '开户行：',
    //             value: '浙商银行舟山分行营业部'
    //         }, {
    //             label: '对公账户：',
    //             value: '3420020010120100174002'
    //         }
    //     ];
    //     var obj1 = [
    //         {
    //             label: '合作方：',
    //             value: '开封市薪企云服人力资源服务有限公司'
    //         }, {
    //             label: '合作方地址：',
    //             value: '开封市鼓楼区省府西街33号嘉斯茂金品数码广场2层1区202'
    //         }, {
    //             label: '合作方开户行：',
    //             value: '中原银行股份有限公司开封卧龙支行'
    //         }, {
    //             label: '合作方对公账户：',
    //             value: '410214010160010701'
    //         }, {
    //             label: '签约合同：',
    //             value: '浙商银行舟山分行营业部'
    //         }
    //     ];
    //
    //     var contractUrl = "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_7711157622797891420191317618914兰和-开封.pdf";
    //     if (qobj.sign_body != "舟山兰和科技有限公司") {
    //         let config = await this.service.getConfig(qobj.sign_body);
    //         return system.getResultSuccess(config);
    //     }
    //     var rs = {};
    //     rs.obj = obj;
    //     rs.obj1 = obj1;
    //     rs.contractUrl = contractUrl;
    //     return system.getResultSuccess(rs);
    // }

    async getMcht() {

    }
}


module.exports = MerchantCtl;
