const system = require("../../../system");
const Dao = require("../../dao.base");

class LoadDao extends Dao {
    constructor() {
        super(Dao.getModelName(LoadDao));
    }

    async statCount(companyNames, sign_body_id) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }
        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body_id) {
            and.push("AND sign_body_id = :sign_body_id");
        }

        var sql = `SELECT company_name, COUNT(1) AS num FROM load_info WHERE ${and.join(" ")} GROUP BY company_name`;

        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body_id: sign_body_id});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.company_name] = item.num || 0;
        }
        return result;
    }

    async sCount(inno) {
        var result = {};
        if(!inno || inno.length == 0) {
            return result;
        }
        var sql = "SELECT id_no, COUNT(1) AS num FROM `load_info` WHERE id_no IN (:inno) GROUP BY id_no";

        let list = await this.customQuery(sql, {inno: inno});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.id_no] = item.num || 0;
        }
        return result;
    }
}

module.exports = LoadDao;
