const system = require("../../../system");
const Dao = require("../../dao.base");

class TransactioninDao extends Dao {
    constructor() {
        super(Dao.getModelName(TransactioninDao));
    }
    async statCount(companyNames, sign_body_id) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }

        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body_id) {
            and.push("AND sign_body_id = :sign_body_id");
        }

        var sql = `SELECT company_name, COUNT(1) AS num FROM transaction_info WHERE ${and.join(" ")} GROUP BY company_name`;

        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body_id: sign_body_id});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.company_name] = item.num || 0;
        }
        return result;
    }

    async statCounts(companyNames, sign_body_id) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }
        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body_id) {
            and.push("AND sign_body_id = :sign_body_id");
        }

        var sql = `SELECT company_name, SUM(actual_amount) amount FROM transaction_info WHERE ${and.join(" ")} GROUP BY company_name`;
        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body_id: sign_body_id});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            // result[item.company_name] = item.amount || 0;
            result[item.company_name] = parseFloat((item.amount || 0).toFixed(2));
        }
        return result;
    }

    async sCount(idno) {
        var result = {};
        if(!idno || idno.length == 0) {
            return result;
        }
        var sql = "SELECT id_no, COUNT(id_no) num FROM `transaction_info` WHERE id_no IN (:idno) GROUP BY id_no";

        let list = await this.customQuery(sql, {idno: idno});

        if(!list || list.length == 0) {
            return result;
        }
        for (var item of list) {
            result[item.id_no] = item.num || 0;
        }
        return result;
    }


    async sCountS(idno) {
        var result = {};
        if(!idno || idno.length == 0) {
            return result;
        }
        var sql = "SELECT id_no, SUM(actual_amount) amount FROM `transaction_info` WHERE id_no IN (:idno) GROUP BY id_no";

        let list = await this.customQuery(sql, {idno: idno});

        if(!list || list.length == 0) {
            return result;
        }
        for (var item of list) {
            result[item.id_no] = parseFloat((item.amount || 0).toFixed(2));
        }
        return result;
    }
}

module.exports = TransactioninDao;
