const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class ElectronicContractService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(ElectronicContractService));
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        if(params.sign_body_id){
            where.sign_body_id = params.sign_body_id;
        }
        if(params.id_no){
            where.id_no = params.id_no
        }
        this.addWhereTime(where, 'completed_date', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];
        var page = await this.getPageList(currentPage, pageSize, where, orderby);
        // if (page && page.rows) {
        //     for (var row of page.rows) {
        //         this.handleDate(row, ["begin_time", "invalid_time"]);
        //     }
        // }
        return page;
    }

    async signPageGroup(params) {
        params.currentPage = Number(params.currentPage || 1);
        params.pageSize = Number(params.pageSize || 10);
        params.company_name = this.trim(params.company_name);
        params.sign_body_id = this.trim(params.sign_body_id);
        params.id_no = this.trim(params.id_no);

        let total = await this.dao.countByIdNo(params);
        if (total == 0) {
            return {count : 0, rows: []}
        }

        params.startRow = (params.currentPage - 1) * params.pageSize;

        let list = await this.dao.listByIdNo(params);
        return {count: total, rows: list};
    }

}

module.exports = ElectronicContractService;
