const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

/**
 * 发票列表
 */
class InvoiceService extends ServiceBase {
  constructor() {
    super("all", ServiceBase.getDaoName(InvoiceService));
  }

  async pageByCondition(params) {
    let currentPage = Number(params.currentPage || 1);
    let pageSize = Number(params.pageSize || 10);

    var where = {};
    if (params.title) {
      where.title = {
        [this.db.Op.like]: "%" + params.title + "%"
      };
    }

    // if(params.id_no){
    //   where.id_no = this.trim(params.id_no);
    // }

    if (params.invoiceType) {
      where.invoiceType = Number(params.invoiceType);
    }

    if(params.sign_body_id) {
      where.sign_body_id = params.sign_body_id;
    }

    if(params.invoiceId) {
      where.id = this.trim(params.invoiceId);
    }
    this.addWhereTime(where, 'invoice_time', params.signBegin, params.signEnd);

    var orderby = [
      ["id", 'desc']
    ];
    var page = await this.getPageList(currentPage, pageSize, where, orderby);
    if (page && page.rows) {
      for (var row of page.rows) {
        this.handleDate(row, ["invoice_time"], "YYYY-MM-DD");
      }
    }
    return page;
  }
}

module.exports = InvoiceService;
