const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");


class MerchantTransferService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(MerchantTransferService));
    }

    async transferList(params) {
        var currentPage = Number(params.currentPage || 1);
        var pageSize = Number(params.pageSize || 10);

        var where = {};

        if (params.merchant_name) {
            where.merchant_name = {
                [this.db.Op.like]: "%" + params.merchant_name + "%"
            };
        }
        if (params.merchant_name) {
            where.merchant_name = {
                [this.db.Op.like]: "%" + params.merchant_name + "%"
            };
        }

        this.addWhereTime(where, 'transfer_at', params.signBegin, params.signEnd, true);

        var page = await this.getPageList(currentPage, pageSize, where);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["begin_time", "invalid_time"], "YYYY-MM-DD");
            }
        }
        return page;
    }

    async test() {
        return "service success"
    }
}

module.exports = MerchantTransferService;
