const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

/**
 * 发票列表
 */
class MerchantAccountService extends ServiceBase {
  constructor() {
    super("all", ServiceBase.getDaoName(MerchantAccountService));
  }

  async setAccount(list, options) {
    if (!list || list.length == 0) {
      return;
    }
    options = options || {};
    let field = options.field || "merchant_account_id";
    let attrs = options.attrs || "id, merchant_id, account_name, account_no, account_bank, legal_name, base_no";

    let ids = [-1];
    for (let item of list) {
      if (!item || !item[field]) {
        continue;
      }
      ids.push(Number(item[field]));
    }
    let map = await this.dao.mapByIds(ids, attrs) || {};
    for (let item of list) {
      item.merchant_account = map[item[field]] || {};
    }
  }
}

module.exports = MerchantAccountService;