const system=require("../system");
class ApiBase{
  constructor(){
     this.cacheManager=system.getObject("db.cacheManager");
  }
  async checkKey(appKey){
     let key = await this.cacheManager["InitAppKeyCache"].getAppKeyVal(appKey);
     if(key==null){
       return system.getResult2(null,null,"ok","请检查您的授权KEY");
     }
  }


    doTimeCondition(params, fields) {
        if (!params || !fields || fields.length == 0) {
            return;
        }
        for (var f of fields) {
            if (params[f]) {
                var suffix = this.endWith(f, 'Begin') ? " 00:00:00" : " 23:59:59";
                params[f] = params[f] + suffix;
            }
        }
    }

    trim(o) {
        if(!o) {
            return "";
        }
        return o.toString().trim();
    }

    getSettleParams(search) {
        var params = search || {};
        if (this.trim(params.createBegin)) {
            params.createBegin = this.trim(params.createBegin) + " 00:00:00";
        }
        if (this.trim(params.createEnd)) {
            params.createEnd = this.trim(params.createEnd) + " 23:59:59";
        }
        return params;
    }

    endWith(source, str){
        if(!str  || !source || source.length == 0 || str.length > source.length) {
            return false;
        }
        return source.substring(source.length - str.length) == str;
    }
}
module.exports=ApiBase;
