var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require('moment');
class EmessageCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(EmessageCtl));
   }

   async entMessageList(queryobj, qobj, req) {
    var user = req.session.user;
    if(!user) {
      return system.getResult2({count:0});
    }

    try {
      var params = {
        user_id: user.id,
        types: [5],
      };
      var rs =  await this.service.getList(params, qobj.currentPage || 1, qobj.pageSize || 5);

      if(rs && rs.rows) {
        for(var row of rs.rows) {
          if(row.created_at) {
            row.created_at = moment(row.created_at).format("YYYY-MM-DD HH:mm:ss");
          }
        }
      }
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

}
module.exports=EmessageCtl;
