var system = require("../../system")
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class EntcontractCtl extends CtlBase {
    constructor() {
        super(CtlBase.getServiceName(EntcontractCtl));

        this.utilesignbaoSve = system.getObject("service.utilesignbaoSve");
    }

    async downloadContractUrl(q, obj, req) {
        let contract = await this.service.findById(obj.id);
        if (!contract) {
            return system.getErrResult2("协议不存在");
        }
        if (contract.fileurl) {
            return system.getResult2(contract.fileurl);
        }

        //  请求文件地址
        let fileRs = await this.utilesignbaoSve.downloadUserContractFile(contract.eflowid, "econtractCtl");
        console.log(fileRs, "===============================================================");
        if (fileRs.code == 1 && fileRs.data.selfossUrl) {
            contract.fileurl = fileRs.data.selfossUrl;
            contract.save();
            return system.getResult2(fileRs.data.selfossUrl);
        }
        return system.getErrResult2("网络繁忙，获取合同失败，请稍后重试");
    }

    async geturl(req){
        try {
            var entid = req.query.entid || 0;
            var data = await this.service.findById(entid);
            if(data && data.eflowstatus == 1){
                return {code :0,data:data.esignUrl}
            }
           return {code:-1,data:"已签约"};
        }catch (e) {
            logCtl.info({e});
        }
    }

}

module.exports = EntcontractCtl;
