const system = require("../../system");
const Dao = require("../dao.base");

class LDUserBankDao extends Dao {
  constructor() {
    super(Dao.getModelName(LDUserBankDao));
  }

  async listByCondition(params) {
    let sql = [];
    sql.push("SELECT");
    sql.push(params.attrs || "*");
    sql.push("FROM");
    sql.push(this.model.tableName);
    sql.push("WHERE 1 = 1");

    if (params.user_id) {
      sql.push("AND user_id = :user_id");
    }
    return await this.customQuery(sql.join(" "), params);
  }
}

module.exports = LDUserBankDao;
