{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            editTitle:"新增意向",
            showDetail: false,
            showEdit: false,
            nameLoading: false,
            submitLoading:false,
            isFirstEdit: true,
            nameList: [],
            nameMap:[],
            ecompanySourceTypeList: [],
            ecompanyLevelList: [],
            eduTypeList: [],
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                name: '',
                ecompanyLevel: '',
                ecompanySourceType: '',
                createdBegin: '',
                createdEnd: '',
                owner_name: '',
            },
            intention: {
                id: "",
            },
            applyDetail: {
                id: '',
                eaccount: {},
            },
            rules: {
                name : [
                    { required: true, message: '请输入客户名称', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                contractName: [
                    { required: true, message: '请输入联系人', trigger: 'blur' },
                ],
                a : [],
            },

            followLoading: false,

            followStatusList: [],
            followStatusMap: [],
            showFollow: false,
            followtab: "1",
            followSearch:{
                list: [],
                currentPage: 1,
                pageSize: 10,
                total : 0,
                eintention_id: 0,
            },
            followInfo: {
            },
        }
    },
    mounted: function () {
        this.getEcompanySourceTypeList();
        this.getEcompanyLevelList();
        this.resetSearch();
        this.getFollowStatusList();
    },
    created: function () {},
    methods: {
        getEcompanySourceTypeList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig", {
                "dicKey": "ecompanySourceType"
            }).then(cfg => {
                self.ecompanySourceTypeList = [];
                Object.keys(cfg.data).forEach(key => {
                    self.ecompanySourceTypeList.push({
                        "label": cfg.data[key],
                        "value": key
                    });
                });
            });
        },
        getEcompanyLevelList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig", {
                "dicKey": "ecompanyLevel"
            }).then(cfg => {
                self.ecompanyLevelList = [];
                Object.keys(cfg.data).forEach(key => {
                    self.ecompanyLevelList.push({
                        "label": cfg.data[key],
                        "value": key
                    });
                });
            });
        },

        getFollowStatusList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig", {
                "dicKey": "efollowStatus"
            }).then(cfg => {
                self.followStatusList = [];
                Object.keys(cfg.data).forEach(key => {
                    self.followStatusMap["key_" + key] = cfg.data[key];
                    self.followStatusList.push({
                        "label": cfg.data[key],
                        "value": key
                    });
                });
            });
        },

        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                name: '',
                ecompanyLevel: '',
                ecompanySourceType: '',
                createdBegin: '',
                createdEnd: '',
                owner_name: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({row, column, rowIndex, columnIndex}) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.getList();
        },
        getList() {
            var self = this;
            this.$root.postReq("/web/eintentionCtl/myList", {
                search: this.getParams()
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {}
            });
        },
        getParams() {
            var params = {};
            for (var f in this.search) {
                if (f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'name') {
                if(!self.intention.name) {
                    return callback(new Error("请输入客户名称"));
                }

                self.$root.postReq("/web/eintentionCtl/validName", {
                    name: self.intention.name
                }).then(function (d) {
                    if (d.status == 0) {
                        return callback();
                    } else {
                        return callback(new Error(d.msg));
                    }
                });
            } else {
                return callback();
            }
        },
        changeStatus() {
            this.curStatus = this.search.applyStatus;
            this.search.currentPage = 1;
            this.search.pageSize = 20;
            this.search.total = 0;
            this.getList();
        },
        openDetail(item) {
            var self = this;
            this.intention = {};
            this.getIntention(item.id, function(data){
                self.showDetail = true;
            })
        },
        openEdit(item) {
            var self = this;
            self.nameList = [];

            if(item) {
                self.editTitle = "修改意向";
                self.getIntention(item.id);
            } else {
                self.editTitle = "新增意向";
            }
            self.showEdit = true;
            if(this.isFirstEdit) {
                this.isFirstEdit = false;
            } else {
                this.$refs.intention.resetFields();
            }
        },
        getIntention(id, cb) {
            var self = this;
            this.$root.postReq("/web/eintentionCtl/findOne", {
                id: id
            }).then(function (d) {
                if (d.status == 0) {
                    self.intention = d.data;
                    if(cb) {
                        cb(d.data);
                    }
                } else {}
            });
        },
        nameChange(val) {
            this.$refs.intention.validateField('name');
            var self = this;
            var item = self.nameMap[val];
            if(item) {
                self.intention.credit_code = item.creditCode;
            }
        },
        getIntentionNames(query) {
            var self = this;
            self.nameLoading = true;
            self.$root.postReq("/web/dataCtl/companySuggest", {
                name: query
            }).then(function (d) {
                self.nameLoading = false;
                self.nameList = d.data || [];
                self.nameMap = [];
                for(var item of self.nameList) {
                    self.nameMap[item.entName] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading = false; 
            }, 15000);
        },
        save() {
            var self = this;

            self.submitLoading = true;
            self.$refs.intention.validate((valid) => {
                if (valid) {
                    setTimeout(() => {
                        self.submitLoading = false;
                    }, 5000);
                    var editUrl = "/web/eintentionCtl/create";
                    if(self.intention.id) {
                        editUrl = "web/eintentionCtl/update";
                    }
                    self.$root.postReq(editUrl, self.intention).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.submitLoading = false;
                    });
                } else {
                    self.submitLoading = false;
                    return false;
                }
            });
        },
        followChange(v) {},

        openFollow(row) {
            this.followtab = "1";
            this.followInfo = {
                eintention_id: row.id,
                content: "",
                followStatus: "",
            };

            this.followSearch = {
                list: [],
                currentPage: 1,
                pageSize: 10,
                total : 0,
                eintention_id: row.id,
            };

            this.showFollow = true;
            this.getFollowList();
        },
        getFollowList() {
            var self = this;
            var params = {
                currentPage: self.followSearch.currentPage,
                pageSize: self.followSearch.pageSize,
                eintention_id: self.followSearch.eintention_id
            };
            self.$root.postReq("/web/eintentionfollowCtl/followList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.followSearch.list = d.data.rows || [];
                    self.followSearch.total = d.data.count || 0;
                } else {
                }
            });
        },
        handleSizeChangeFollow(val) {
            this.followSearch.list = [];
            this.followSearch.currentPage = 1;
            this.followSearch.pageSize = val;
            this.followSearch.total = 0;
            this.getFollowList();
        },
        handleCurrentChangeFollow(val) {
            this.followSearch.currentPage = val;
            this.getFollowList();
        },

        addFollow() {
            var self = this;
            if(!self.followInfo.eintention_id) {
                self.$message.warning(`请重新选择意向客户`);
                return;
            }

            if(!self.followInfo.followStatus) {
                self.$message.warning(`请选择客户意向`);
                return;
            }

            self.followInfo.followStatusName = self.followStatusMap["key_" + self.followInfo.followStatus];
            if(!self.followInfo.followStatusName) {
                self.$message.warning(`意向客户选择错误`);
                return;
            }

            if(!self.followInfo.content || !self.followInfo.content.trim()) {
                self.$message.warning(`请输入跟进内容`);
                return;
            }

            self.followLoading = true;

            self.$root.postReq("/web/eintentionfollowCtl/addFollow", self.followInfo).then(function (d) {
                self.followLoading = false;
                if (d.status == 0) {
                    self.$message.success(`添加成功`);
                    self.getFollowList();
                    self.followtab = "2";
                    self.followInfo.content = "";
                    self.followInfo.followStatus = "";
                } else {
                    self.$message.warning(`添加失败`);
                }
            });

            setTimeout(() => {
                self.followLoading = false;
            }, 5000);
        },
    },
    vname: "gsb-eintentionmy"
}