var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
var cacheBaseComp = null;

class TemplatelinkCtl extends CtlBase {
    constructor() {
        super("template", CtlBase.getServiceName(TemplatelinkCtl));
        this.templatelinkSve = system.getObject('service.template.templatelinkSve');
    }

    /**
     * 重写保存方法
     * @param pobj
     * @returns {Promise<void>}
     */
    async create(pobj){
        let result =  await this.templatelinkSve.createTemplateLink(pobj);
        return result;
    }

    /**
     * 修改投放状态
     * @param {*} pobj 
     */
    async updateLaunchStatus(pobj){
        var result =  await this.service.updateLaunchStatus(pobj);
        return result;
    }

    async delete(pobj, qobj, req) {
        const up = await this.templatelinkSve.deleteTemplateLink(pobj);
        return system.getResult(up);
    }
}

module.exports = TemplatelinkCtl;
