/**
 * 投放渠道信息表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
module.exports = (db, DataTypes) => {
    return db.define("launchtype", {
        code: DataTypes.STRING(100),//表单编码
        name: DataTypes.STRING(100),//表单名称
        notes: DataTypes.STRING(255),//备注
        user_id: DataTypes.INTEGER(11),//创建用户id
        user_name: DataTypes.STRING(60),//创建用户名称
        company_id: DataTypes.INTEGER(11)
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        timestamps: true,
        updated_at: true,
        tableName: 'c_launch_type',
        validate: {},
        indexes: []
    });
}

