var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const logCtl = system.getObject("web.common.oplogCtl");

var cacheBaseComp = null;
class ManagerCtl extends CtlBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.order.orderSve");
    this.invoiceSve = system.getObject("service.invoice.invoiceSve");
  }

  /**
   * 首页交易数据
   * @param {*} pobj 
   */
  async transData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
      };
      // 交易数据
      return await this.orderSve.statManageData(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  /**
   * 首页业务数据
   * @param {*} pobj 
   */
  async businessData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
      };
      // 业务数据
      return await this.orderSve.statBusinessData(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async deliverData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
        currentPage: pobj.currentPage || 1,
        pageSize: pobj.pageSize || 10,
      }
      // 业务办理概览
      return await this.orderSve.statDeliverData(params);

    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  // 交付商统计
  async deliverStatTransData(pobj, pobj2, req) {
    if(!pobj.current_date){
      let nowTime =new Date();
      let month = nowTime.getMonth() + 1;
      month = month<10?"0"+month:month;
      pobj.current_date = nowTime.getFullYear()+"-"+month;
    }
    pobj.deliver_id = req.body.deliver_id;
    try {
      return await this.orderSve.deliverStatTransData(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  // 业务办理
  async businessManagement(pobj, pobj2, req) {
    if(!pobj.current_date){
      let nowTime =new Date();
      let month = nowTime.getMonth() + 1;
      month = month<10?"0"+month:month;
      pobj.current_date = nowTime.getFullYear()+"-"+month;
    }
    pobj.deliver_id = req.body.deliver_id;
    try {
      return await this.orderSve.businessManagement(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }

  }



}
module.exports = ManagerCtl;