var fs = require("fs");
var objsettings = require("../config/objsettings");
var settings = require("../config/settings");
class System {
	static declare(ns) {
		var ar = ns.split('.');
		var root = System;
		for (var i = 0, len = ar.length; i < len; ++i) {
			var n = ar[i];
			if (!root[n]) {
				root[n] = {};
				root = root[n];
			} else {
				root = root[n];
			}
		}
	}
	static register(key, ClassObj) {
		if (System.objTable[key] != null) {
			throw new Error("相同key的对象已经存在");
		} else {
			let obj = new ClassObj();
			System.objTable[key] = obj;
		}

		return System.objTable[key];
	}
	static getResult(data, opmsg = "操作成功", req) {
		return {
			status: !data ? -1 : 0,
			msg: opmsg,
			data: data || null,
			bizmsg: req && req.session && req.session.bizmsg ? req.session.bizmsg : "empty"
		};
	}
	/**
	 * 请求返回成功
	 * @param {*} data 操作成功返回的数据
	 * @param {*} okmsg 操作成功的描述
	 */
	static getResultSuccess(data, okmsg = "success") {
		return {
			status: 0,
			msg: okmsg,
			data: data || null,
		};
	}
	/**
	 * 请求返回失败
	 * @param {*} status 操作失败状态，默认为-1
	 * @param {*} errmsg 操作失败的描述，默认为fail
	 * @param {*} data 操作失败返回的数据
	 */
	static getResultFail(status = -1, errmsg = "fail", data = null) {
		return {
			status: status,
			msg: errmsg,
			data: data,
		};
	}
	static getObject(objpath) {
		var pathArray = objpath.split(".");
		var packageName = pathArray[0];
		var groupName = pathArray[1];
		var filename = pathArray[2];
		var classpath = "";
		if (filename) {
			classpath = objsettings[packageName] + "/" + groupName;
		} else {
			classpath = objsettings[packageName];
			filename = groupName;
		}

		var objabspath = classpath + "/" + filename + ".js";
		if (System.objTable[objabspath] != null) {
			console.log("get cached obj");
			return System.objTable[objabspath];
		} else {
			console.log("no cached...");
			var ClassObj = require(objabspath);
			return System.register(objabspath, ClassObj);
		}
	}
	static getUiConfig(appid) {
		var configPath = settings.basepath + "/app/base/db/metadata/" + appid + "/index.js";
		if (settings.env == "dev") {
			delete require.cache[configPath];
		}
		var configValue = require(configPath);
		return configValue;
	}
	static getUiConfig2(appid) {
		var configPath = settings.basepath + "/app/base/db/metadata/index.js";
		// if(settings.env=="dev"){
		// 	console.log("delete "+configPath+"cache config");
		// 	delete require.cache[configPath];
		// }
		delete require.cache[configPath];
		var configValue = require(configPath);
		return configValue[appid];
	}
	static get_client_ip(req) {
		var ip = req.headers['x-forwarded-for'] ||
			req.ip ||
			req.connection.remoteAddress ||
			req.socket.remoteAddress ||
			(req.connection.socket && req.connection.socket.remoteAddress) || '';
		var x = ip.match(/(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$/);
		if (x) {
			return x[0];
		} else {
			return "localhost";
		}

	};

	static y2f(y) {
		if (!y) {
			return 0;
		}
		return (Number(y) * 100).toFixed(0);
	}

	static f2y(f) {
		if (!f) {
			return 0;
		}
		return parseFloat((Number(f) / 100).toFixed(2));
	}

	static f2y4list(list, fields, prev) {
		if (!list || list.length == 0 || !fields || fields.length == 0) {
			return;
		}
		prev = prev || "";
		for (var item of list) {
			for (var f of fields) {
				var v = item[f] || 0;
				try {
					item[f + "_y"] = prev + parseFloat((Number(v) / 100).toFixed(2));
				} catch (error) {
					console.log(error);
				}
			}
		}
	}
	static getUid(len, radix) {
		var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');
		var uuid = [],
			i;
		radix = radix || chars.length;
		if (len) {
			for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
		} else {
			var r;
			uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
			uuid[14] = '4';
			for (i = 0; i < 36; i++) {
				if (!uuid[i]) {
					r = 0 | Math.random() * 16;
					uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
				}
			}
		}
		return uuid.join('');
	}

	static microsetting() {
		console.log(settings.env, "-------------- microsetting env ------------------");
		var path = "/api/op/action/springboard";
		if (settings.env == "dev") {
			// var domain = "http://192.168.18.237";
			var domain = "http://127.0.0.1";
			var domain2 = "http://39.107.234.14";
			return {
				// 公共服务
				common: domain2 + ":3102" + path,
				// common: "http://127.0.0.1:3102" + path,

				// 商户服务
				merchant: domain2 + ":3101" + path,
				// merchant: "http://127.0.0.1:3101" + path,

				// 订单服务
				order: domain2 + ":3103" + path,
				// order: "http://127.0.0.1:3103" + path,

				// 发票服务
				invoice: domain + ":3105" + path,
				// invoice: "http://127.0.0.1:3105" + path,

				// 发票服务
				uc: domain2 + ":3106" + path,
				// uc: "http://127.0.0.1:3106" + path,
			}
		} else {
			var odomain = "http://123.57.217.203"
			return {
				common: "xggsvecommon-service" + path,
				merchant: "xggsvemerchant-service" + path,
				order: "xggsveorder-service" + path,
				invoice: "xggsveinvoice-service" + path,
				uc: "xggsveuc-service" + path,
			}
		}
	}
}
Date.prototype.Format = function (fmt) { //author: meizz
	var o = {
		"M+": this.getMonth() + 1, //月份
		"d+": this.getDate(), //日
		"h+": this.getHours(), //小时
		"m+": this.getMinutes(), //分
		"s+": this.getSeconds(), //秒
		"q+": Math.floor((this.getMonth() + 3) / 3), //季度
		"S": this.getMilliseconds() //毫秒
	};
	if (/(y+)/.test(fmt))
		fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	for (var k in o)
		if (new RegExp("(" + k + ")").test(fmt))
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
	return fmt;
}
System.objTable = {};
//访问token失效，请重新获取
System.tokenFail = 1000;
//appKey授权有误
System.appKeyError = 1100;
//应用处于待审核等待启用状态
System.waitAuditApp = 1110;
//访问appid失效，请重新获取
System.appidFail = 1200;
//签名验证失败，请重新获取
System.signFail = 1300;
//获取访问token失败
System.getAppInfoFail = 1130;
module.exports = System;