var APIBase = require("../../api.base");
var system = require("../../../system");
class EnterpriseQueryAPI extends APIBase {
    constructor() {
        super();
        this.enterSve = system.getObject("service.enterprise.enterpriseSve");
    }

    /**
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionType, pobj.actionBody);
        return result;
    }

    async opActionProcess(action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "gxCountByAuthor"://获取企业高薪信息数量
                opResult = await this.enterSve.gxCountByAuthor(action_body);
                break;
            case "gxListByAuthor"://获取企业高薪信息列表
                opResult = await this.enterSve.gxListByAuthor(action_body);
                break;
            case "gameCountByAuthor"://获取企业游戏出版及运营数量
                opResult = await this.enterSve.gameCountByAuthor(action_body);
                break;
            case "gameListByAuthor"://获取企业游戏出版及运营信息列表
                opResult = await this.enterSve.gameListByAuthor(action_body);
                break;
            case "licenseCountByAuthor"://获取企业证照信息数量
                opResult = await this.enterSve.licenseCountByAuthor(action_body);
                break;
            case "licenseListByAuthor"://获取企业证照信息列表
                opResult = await this.enterSve.licenseListByAuthor(action_body);
                break;
            case "ipCountByAuthor"://获取企业域名信息数量
                opResult = await this.enterSve.ipCountByAuthor(action_body);
                break;
            case "ipListByAuthor"://获取企业域名信息列表
                opResult = await this.enterSve.ipListByAuthor(action_body);
                break;
            case "getQccBranches"://获取企业的分支机构（从企查查获取）
                opResult = await this.enterSve.getQccBranches(action_body);
                break;
            case "getcountAll"://获取企业所有证照数量
                opResult = await this.enterSve.getcountAll(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = EnterpriseQueryAPI;

// var tesk = new EnterpriseQueryAPI();
// var parm = {
//     actionType:"getLicenses",
//     actionBody:{name:"上海盛霄云计算技术有限公司"}
//  };
// tesk.springBoard(parm).then(function(result){
//   console.log(result);
//  //console.log(result.data.data[0]);
// }).catch(function(e){
//   console.log(e);
// });