var APIBase = require("../../api.base");
var system = require("../../../system");
class LicenseQueryAPI extends APIBase {
    constructor() {
        super();
        this.liecseSve = system.getObject("service.licenses.licenseSve");
    }

    /**
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionType, pobj.actionBody);
        return result;
    }

    async opActionProcess(action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getLicenses"://根据公司得到推荐要办的证书
                opResult = await this.liecseSve.getLicenses(action_body);
                break;
            // case "getLicenfgfg"://根据公司得到推荐要办的证书
            //     opResult = await this.liecseSve.getLicenfgfg(action_body);
            //     break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = LicenseQueryAPI;

// var tesk = new LicenseQueryAPI();
// var parm = {
//     actionType:"getLicenses",
//     actionBody:{name:"上海盛霄云计算技术有限公司"}
//  };
// tesk.springBoard(parm).then(function(result){
//   console.log(result);
//  //console.log(result.data.data[0]);
// }).catch(function(e){
//   console.log(e);
// });