var APIBase = require("../../api.base");
var system = require("../../../system");
class PatentQueryAPI extends APIBase {
    constructor() {
        super();
        this.cpatentsearchApi = system.getObject("api.patent.chinapatentsearch");
        this.cpatentaggApi = system.getObject("api.patent.cpatentaggregations");
        this.caffairsearchApi = system.getObject("api.patent.chinaaffairsearch");
        this.wpatentsearchApi = system.getObject("api.patent.wordpatentsearch");
        this.wpatentaggApi = system.getObject("api.patent.wpatentaggregations");
        this.copyrightApi = system.getObject("api.patent.copyrightsearch");
    }

    /**
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionType, pobj.actionBody);
        return result;
    }

    async opActionProcess(action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "CommomSearchbyApplicant"://根据申请人查询聚合
                opResult = await this.cpatentsearchApi.CommomSearchbyApplicant(action_body);
                break;
            case "paCountByApplicantName"://根据申请人获取专利量
                opResult = await this.cpatentsearchApi.paCountByApplicantName(action_body);
                break;
            case "paShortListByApplicantName"://根据申请人获取专利详情列表
                opResult = await this.cpatentsearchApi.paShortListByApplicantName(action_body);
                break;
            case "paDetailsBypubNo"://根据公开或授权号获取专利详情列表
                opResult = await this.cpatentsearchApi.paDetailsBypubNo(action_body);
                break;
            case "paDetailsByfilingNo"://根据申请号获取专利详情列表
                opResult = await this.cpatentsearchApi.paDetailsByfilingNo(action_body);
                break;
            case "softwareCountByAuthor"://根据公司名称得到软著量
                opResult = await this.copyrightApi.softwareCountByAuthor(action_body);
                break;
            case "softwareListByAuthor"://根据公司名称得到软著详情
                opResult = await this.copyrightApi.softwareListByAuthor(action_body);
                break;
            case "softwareDetailsByregNum"://根据登记号获取软著详情
                opResult = await this.copyrightApi.softwareDetailsByregNum(action_body);
                break;
            case "worksCountByAuthor"://根据公司名称得到著作权量
                opResult = await this.copyrightApi.worksCountByAuthor(action_body);
                break;
            case "worksListByAuthor"://根据公司名称得到著作权详情
                opResult = await this.copyrightApi.worksListByAuthor(action_body);
                break;
            case "worksDetailsByregNum"://根据登记号获取著作权详情
                opResult = await this.copyrightApi.worksDetailsByregNum(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = PatentQueryAPI;

// var tesk = new PatentQueryAPI();
// var parm = {
//     actionType:"paShortListByApplicantName",
//     actionBody:{applicant_name:"中国专利信息中心"}
//  };
// tesk.springBoard(parm).then(function(result){
//   console.log(result);
//  console.log(result.data.data[0]);
// }).catch(function(e){
//   console.log(e);
// });